/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.balancers;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.ILoadBalancer;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.strategies.MultipleQueuesStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class OriginalAbstractLoadBalancer
implements ILoadBalancer {
    protected double balance_interval;
    protected Hashtable<IResourceInstance, Double> last_load;
    protected MultipleQueuesStrategy queue_holder;
    protected boolean prio_increasing;
    protected boolean queue_ascending;

    protected OriginalAbstractLoadBalancer(double balance_interval, boolean do_global_balance, boolean prio_increasing, boolean queue_ascending, int max_iterations) {
        this.balance_interval = balance_interval;
        this.prio_increasing = prio_increasing;
        this.queue_ascending = queue_ascending;
        this.queue_holder = null;
        this.last_load = new Hashtable();
    }

    public void setQueueHolder(MultipleQueuesStrategy queue_holder) {
        this.queue_holder = queue_holder;
        for (IResourceInstance instance : queue_holder.getResourceInstances()) {
            this.last_load.put(instance, 0.0);
        }
    }

    protected abstract boolean isBalanced(IResourceInstance var1, IResourceInstance var2);

    @Override
    public void activelyBalance(IResourceInstance instance) {
        double load = this.queue_holder.getRunQueueFor(instance).getCurrentLoad();
        if (MathTools.less((double)0.0, (double)Math.abs(load - this.last_load.get(instance)))) {
            this.doBalance(instance);
        }
        this.last_load.put(instance, load);
    }

    protected void balanceTwoInstances(IResourceInstance src, IResourceInstance dest, int max_processes_needed) {
        List<IActiveProcess> movable_process_list = this.identifyMovableProcesses(src, dest, max_processes_needed);
        Iterator<IActiveProcess> iterator = movable_process_list.iterator();
        while (iterator.hasNext() && this.load(src) > 1 && !this.isBalanced(src, dest)) {
            this.queue_holder.move(iterator.next(), src, dest);
        }
        src.schedulingInterrupt(0.0);
        dest.schedulingInterrupt(0.0);
    }

    protected List<IActiveProcess> identifyMovableProcesses(IResourceInstance source_instance, IResourceInstance target_instance, int processes_needed) {
        return this.queue_holder.getRunQueueFor(source_instance).identifyMovableProcesses(target_instance, this.prio_increasing, this.queue_ascending, processes_needed);
    }

    protected int load(IResourceInstance instance) {
        int queueLength = this.queue_holder.getRunQueueFor(instance).getCurrentLoad();
        if (instance.getRunningProcess() != null) {
            ++queueLength;
        }
        return queueLength;
    }

    protected IResourceInstance getBusiest(Collection<IResourceInstance> instance_list) {
        IResourceInstance busiest = null;
        for (IResourceInstance instance : instance_list) {
            if (busiest != null && this.load(instance) <= this.load(busiest)) continue;
            busiest = instance;
        }
        return busiest;
    }

    protected IResourceInstance getLaziest(Collection<IResourceInstance> instance_list) {
        IResourceInstance laziest = null;
        for (IResourceInstance instance : instance_list) {
            if (laziest != null && this.load(instance) >= this.load(laziest)) continue;
            laziest = instance;
        }
        return laziest;
    }

    protected List<IResourceInstance> getInstancesWithMoreThanOneProcess() {
        ArrayList<IResourceInstance> busyQueues = new ArrayList<IResourceInstance>();
        for (IResourceInstance instance : this.queue_holder.getResourceInstances()) {
            if (this.load(instance) <= 1) continue;
            busyQueues.add(instance);
        }
        return busyQueues;
    }

    protected int numProcessedNeeded(IResourceInstance first_instance, IResourceInstance second_instance) {
        int firstLoad = this.load(first_instance);
        int secondLoad = this.load(second_instance);
        return Math.abs(firstLoad - secondLoad) / 2;
    }

    protected void doBalance(IResourceInstance instance) {
        IResourceInstance busiest = this.getBusiest(this.queue_holder.getResourceInstances());
        IResourceInstance idlest = this.getLaziest(this.queue_holder.getResourceInstances());
        if (!busiest.equals(instance) && !this.isBalanced(busiest, instance) && this.load(busiest) > 1) {
            int max_processes_needed = this.numProcessedNeeded(busiest, instance);
            this.balanceTwoInstances(busiest, instance, max_processes_needed);
        } else if (!idlest.equals(instance) && !this.isBalanced(idlest, instance) && this.load(instance) > 1) {
            int max_processes_needed = this.numProcessedNeeded(instance, idlest);
            this.balanceTwoInstances(instance, idlest, max_processes_needed);
        }
    }
}

