/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.extension.model.ExtensionmodelFactory;
import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.bpel.common.ui.editmodel.EditModelClient;
import org.eclipse.bpel.common.ui.editmodel.EditModelCommandStack;
import org.eclipse.bpel.common.ui.editmodel.IEditModelListener;
import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.util.BPELEditModel;
import org.eclipse.bpel.ui.util.CommandStackChangeBatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLFactory;

public class BPELEditModelClient
extends EditModelClient {
    private ResourceInfo extensionsResourceInfo;
    private ResourceInfo artifactsResourceInfo;
    BPELEditModel bpelEditModel;

    public BPELEditModelClient(IEditorPart editor) {
        super(editor, (IEditModelListener)editor);
    }

    public void loadPrimaryResource(IFile file, Map loadOptions) throws RuntimeException {
        super.loadPrimaryResource(file, loadOptions);
        this.bpelEditModel = (BPELEditModel)this.getEditModel();
        this.getPrimaryResourceInfo().getResource();
    }

    public void loadExtensionsResource() throws RuntimeException {
        if (this.bpelEditModel == null || this.getPrimaryResourceInfo() == null) {
            throw new RuntimeException("Primary resource must be loaded before Extensions");
        }
        IFile extensionsFile = this.bpelEditModel.getExtensionsFile();
        if (extensionsFile.exists()) {
            this.extensionsResourceInfo = this.bpelEditModel.getResourceInfo(extensionsFile);
        } else {
            Resource bpelexResource = this.bpelEditModel.getResourceSet().createResource(URI.createPlatformResourceURI((String)extensionsFile.getFullPath().toString()));
            this.extensionsResourceInfo = this.bpelEditModel.getResourceInfo(extensionsFile);
            ExtensionMap extensionMap = ExtensionmodelFactory.eINSTANCE.createExtensionMap("http://org.eclipse.bpel.ui/");
            bpelexResource.getContents().add((Object)extensionMap);
        }
    }

    public void loadArtifactsResource() throws RuntimeException {
        if (this.bpelEditModel == null || this.getPrimaryResourceInfo() == null) {
            throw new RuntimeException("Primary resource must be loaded before Artifacts");
        }
        IFile artifactsFile = this.bpelEditModel.getArtifactsFile();
        if (artifactsFile.exists()) {
            this.artifactsResourceInfo = this.bpelEditModel.getResourceInfo(artifactsFile);
        } else {
            Resource artifactsResource = this.bpelEditModel.getResourceSet().createResource(URI.createPlatformResourceURI((String)artifactsFile.getFullPath().toString()));
            Definition artifactsDefn = WSDLFactory.eINSTANCE.createDefinition();
            artifactsDefn.setLocation(artifactsResource.getURI().toString());
            EList bpelContents = this.getPrimaryResourceInfo().getResource().getContents();
            if (!bpelContents.isEmpty() && bpelContents.get(0) instanceof Process) {
                Process process = (Process)bpelContents.get(0);
                artifactsDefn.setTargetNamespace(String.valueOf(process.getTargetNamespace()) + "Artifacts");
                artifactsDefn.setQName(new QName(artifactsDefn.getTargetNamespace(), artifactsFile.getFullPath().removeFileExtension().lastSegment()));
            }
            artifactsResource.getContents().add((Object)artifactsDefn);
            this.artifactsResourceInfo = this.bpelEditModel.getResourceInfo(artifactsFile);
        }
    }

    protected EditModelCommandStack createCommandStack() {
        EditModelCommandStack commandStack = super.createCommandStack();
        commandStack.setUndoLimit(50);
        commandStack.addCommandStackListener((CommandStackListener)new CommandStackChangeBatcher());
        return commandStack;
    }

    public void dispose() {
        if (this.artifactsResourceInfo != null) {
            this.bpelEditModel.releaseReference(this.artifactsResourceInfo);
        }
        if (this.extensionsResourceInfo != null) {
            this.bpelEditModel.releaseReference(this.extensionsResourceInfo);
        }
        super.dispose();
    }

    protected EditModel getSharedResourceSet(IFile file) {
        return BPELEditModel.getEditModel((IResource)file);
    }

    public ResourceInfo getArtifactsResourceInfo() {
        return this.artifactsResourceInfo;
    }

    public ResourceInfo getExtensionsResourceInfo() {
        return this.extensionsResourceInfo;
    }

    public IFile getExtensionsFile() {
        return this.bpelEditModel.getExtensionsFile();
    }

    public IFile getArtifactsFile() {
        return this.bpelEditModel.getArtifactsFile();
    }
}

