/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugElement;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugThread;
import org.eclipse.emf.henshin.interpreter.matching.conditions.DebugApplicationCondition;

public class HenshinDebugTarget
extends HenshinDebugElement
implements IDebugTarget {
    private ILaunch launch;
    private HenshinDebugThread debugThread;
    private IFile moduleFile;
    private String name;
    private IThread[] threads;

    public HenshinDebugTarget(ILaunch launch, String ruleName) {
        super(null);
        this.launch = launch;
        if (ruleName != null && !ruleName.isEmpty()) {
            this.setName("Debugging Rule \"" + ruleName + "\"");
        } else {
            this.setName("HenshinDebugTarget");
        }
    }

    public void initTarget(DebugApplicationCondition applicationCondition, IFile moduleFile) {
        this.debugThread = new HenshinDebugThread(this, applicationCondition);
        this.moduleFile = moduleFile;
        this.fireCreationEvent();
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public IFile getModuleFile() {
        return this.moduleFile;
    }

    public boolean canTerminate() {
        return this.debugThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.debugThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.debugThread.terminate();
    }

    public boolean canResume() {
        return this.debugThread.canResume();
    }

    public boolean canSuspend() {
        return this.debugThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.debugThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.debugThread.resume();
    }

    public void suspend() throws DebugException {
        this.debugThread.suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        if (this.threads == null) {
            this.threads = new IThread[]{this.debugThread};
        }
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public void dispose() {
        this.fireTerminateEvent();
    }

    public void fireEvent(DebugEvent event) {
        try {
            DebugEvent threadEvent = new DebugEvent((Object)this.getThreads()[0], event.getKind(), event.getDetail());
            if (DebugPlugin.getDefault() != null) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event, threadEvent});
            }
        }
        catch (DebugException debugException) {}
    }
}

