/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.draw2d.labels;

import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class VerticalLabel
extends ImageFigure {
    private String myText;
    private Font myImageFont;
    private Color myForegroundColor;
    private Color myBackgroundColor;

    public void addNotify() {
        this.updateImage();
        super.addNotify();
    }

    public void removeNotify() {
        if (super.getImage() != null) {
            super.getImage().dispose();
        }
        super.removeNotify();
    }

    public Image getImage() {
        boolean update = false;
        if (this.myImageFont != this.getFont()) {
            this.myImageFont = this.getFont();
            update = true;
        }
        if (VerticalLabel.needsUpdate(this.myForegroundColor, this.getForegroundColor())) {
            this.myForegroundColor = this.getForegroundColor();
            update = true;
        }
        if (VerticalLabel.needsUpdate(this.myBackgroundColor, this.getBackgroundColor())) {
            this.myBackgroundColor = this.getBackgroundColor();
            update = true;
        }
        if (update) {
            return this.updateImage();
        }
        return super.getImage();
    }

    public void setText(String text) {
        if (!VerticalLabel.safeEquals(text, this.myText)) {
            this.myText = text;
            this.updateImage();
        }
    }

    public String getText() {
        return this.myText;
    }

    private Image updateImage() {
        if (super.getImage() != null) {
            super.getImage().dispose();
        }
        if (this.getText() == null) {
            return null;
        }
        if (this.getFont() == null) {
            return null;
        }
        String safeText = this.getText();
        if (safeText.length() == 0) {
            safeText = " ";
        }
        Image image = ImageUtilities.createRotatedImageOfString((String)safeText, (Font)this.getFont(), (Color)this.getForegroundColor(), (Color)this.getBackgroundColor());
        super.setImage(image);
        return image;
    }

    private static final boolean needsUpdate(Color cachedColor, Color actualColor) {
        if (cachedColor == null && actualColor == null) {
            return false;
        }
        return cachedColor == null || !cachedColor.equals((Object)actualColor);
    }

    private static boolean safeEquals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }
}

