/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustAbsoluteBendpointsEditPolicyBase;

public class AdjustBorderItemAnchorsEditPolicy
extends AdjustAbsoluteBendpointsEditPolicyBase {
    public static final String ROLE = String.valueOf(AdjustBorderItemAnchorsEditPolicy.class.getName()) + ":Role";

    @Override
    protected Command getAdjustLinksCommand(ChangeBoundsRequest req) {
        if (this.getHost() instanceof IBorderItemEditPart && this.getHost() instanceof INodeEditPart) {
            return this.getAdjustAnchorsCommand(req);
        }
        return null;
    }

    protected Command getAdjustAnchorsCommand(ChangeBoundsRequest req) {
        SetConnectionAnchorsCommand nextCommand;
        String newTerminal;
        PrecisionPoint newRefPoint;
        ConnectionEditPart nextLink;
        ConnectionAnchor anchor;
        IBorderItemEditPart host = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator locator = host.getBorderItemLocator();
        if (locator == null) {
            return null;
        }
        Rectangle bounds = host.getFigure() instanceof HandleBounds ? ((HandleBounds)host.getFigure()).getHandleBounds() : host.getFigure().getBounds();
        PrecisionRectangle rect = new PrecisionRectangle(bounds);
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(req.getMoveDelta());
        rect.resize(req.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        Rectangle realLocation = locator.getValidLocation(rect.getCopy(), host.getFigure());
        int projectedSide = BorderItemLocator.findClosestSideOfParent((Rectangle)realLocation, (Rectangle)((GraphicalEditPart)host.getParent()).getFigure().getBounds());
        int currentSide = locator.getCurrentSideOfParent();
        int curIndex = AdjustBorderItemAnchorsEditPolicy.getIndexForSide(currentSide);
        int projectedIndex = AdjustBorderItemAnchorsEditPolicy.getIndexForSide(projectedSide);
        if ((projectedSide & currentSide) != 0) {
            return null;
        }
        int rotation = projectedIndex - curIndex;
        if (rotation < 0) {
            rotation += 4;
        }
        if (rotation == 0) {
            return null;
        }
        SetConnectionAnchorsCommand result = null;
        TransactionalEditingDomain domain = this.getHost().getEditingDomain();
        for (Object next : this.getHost().getSourceConnections()) {
            if (!(next instanceof ConnectionEditPart) || (anchor = (nextLink = (ConnectionEditPart)next).getConnectionFigure().getSourceAnchor()) == null) continue;
            newRefPoint = this.rotateAnchorLocation(anchor, rotation);
            newTerminal = this.composeTerminalString(newRefPoint);
            nextCommand = new SetConnectionAnchorsCommand(domain, "Adjusting source anchors");
            nextCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)nextLink.getNotationView()));
            nextCommand.setNewSourceTerminal(newTerminal);
            Object object = result = result == null ? nextCommand : result.compose((IUndoableOperation)nextCommand);
        }
        for (Object next : this.getHost().getTargetConnections()) {
            if (!(next instanceof ConnectionEditPart) || (anchor = (nextLink = (ConnectionEditPart)next).getConnectionFigure().getTargetAnchor()) == null) continue;
            newRefPoint = this.rotateAnchorLocation(anchor, rotation);
            newTerminal = this.composeTerminalString(newRefPoint);
            nextCommand = new SetConnectionAnchorsCommand(domain, "Adjusting target anchors");
            nextCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)nextLink.getNotationView()));
            nextCommand.setNewTargetTerminal(newTerminal);
            Object object = result = result == null ? nextCommand : result.compose((IUndoableOperation)nextCommand);
        }
        return result == null ? null : new ICommandProxy(result);
    }

    private static int getIndexForSide(int side) {
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(side, 1)) {
            return 0;
        }
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(side, 16)) {
            return 1;
        }
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(side, 4)) {
            return 2;
        }
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(side, 8)) {
            return 3;
        }
        return 0;
    }

    protected static String position2string(int position) {
        if (position == 0) {
            return "NONE";
        }
        StringBuffer result = new StringBuffer();
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(position, 1)) {
            result.append("N");
        }
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(position, 4)) {
            result.append("S");
        }
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(position, 8)) {
            result.append("W");
        }
        if (AdjustBorderItemAnchorsEditPolicy.hasBits(position, 16)) {
            result.append("E");
        }
        return result.toString();
    }

    protected static boolean hasBits(int value, int mask) {
        return (value & mask) != 0;
    }

    protected PrecisionPoint rotateAnchorLocation(ConnectionAnchor anchor, int quarters) {
        String terminal = ((BaseSlidableAnchor)anchor).getTerminal();
        PrecisionPoint result = terminal.length() == 0 ? new PrecisionPoint(0.5, 0.5) : BaseSlidableAnchor.parseTerminalString((String)terminal);
        int i = 0;
        while (i < quarters) {
            double newX = 1.0 - result.preciseY();
            double newY = result.preciseX();
            result.setPreciseLocation(newX, newY);
            ++i;
        }
        return result;
    }

    @Deprecated
    private String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append(p.preciseX());
        s.append(',');
        s.append(p.preciseY());
        s.append(')');
        return s.toString();
    }
}

