/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.policies;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.requests.ReconnectRequest;

public class LinksLFConnectionEndPointEditPolicy
extends SelectionHandlesEditPolicy {
    private ConnectionAnchor originalAnchor;
    private FeedbackHelperEx feedbackHelper;
    private ConnectionFocus focus;

    protected List createSelectionHandles() {
        ArrayList<ConnectionEndpointHandle> list = new ArrayList<ConnectionEndpointHandle>();
        list.add(new ConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 2));
        list.add(new ConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 3));
        return list;
    }

    protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
        if (this.originalAnchor == null) {
            return;
        }
        if (request.isMovingStartAnchor()) {
            this.getConnection().setSourceAnchor(this.originalAnchor);
        } else {
            this.getConnection().setTargetAnchor(this.originalAnchor);
        }
        this.originalAnchor = null;
        this.feedbackHelper = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("Reconnection target".equals(request.getType()) || "Reconnection source".equals(request.getType())) {
            this.eraseConnectionMoveFeedback((ReconnectRequest)request);
        }
    }

    public Command getCommand(Request request) {
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected FeedbackHelperEx getFeedbackHelper(ReconnectRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelperEx();
            this.feedbackHelper.setConnection(this.getConnection());
            this.feedbackHelper.setMovingStartAnchor(request.isMovingStartAnchor());
        }
        return this.feedbackHelper;
    }

    protected void hideFocus() {
        if (this.focus != null) {
            this.removeFeedback((IFigure)this.focus);
            this.focus = null;
        }
    }

    protected void showConnectionMoveFeedback(ReconnectRequest request) {
        NodeEditPart node = null;
        if (request.getTarget() instanceof NodeEditPart) {
            node = (NodeEditPart)request.getTarget();
        }
        if (this.originalAnchor == null) {
            this.originalAnchor = request.isMovingStartAnchor() ? this.getConnection().getSourceAnchor() : this.getConnection().getTargetAnchor();
        }
        ConnectionAnchor anchor = null;
        if (node != null) {
            anchor = request.isMovingStartAnchor() ? node.getSourceConnectionAnchor((Request)request) : node.getTargetConnectionAnchor((Request)request);
        }
        FeedbackHelperEx helper = this.getFeedbackHelper(request);
        helper.update(anchor, request.getLocation());
    }

    protected void showFocus() {
        if (this.focus == null) {
            this.focus = new ConnectionFocus();
            this.addFeedback((IFigure)this.focus);
        }
    }

    public void showSourceFeedback(Request request) {
        if ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.showConnectionMoveFeedback((ReconnectRequest)request);
        }
    }

    class ConnectionFocus
    extends Polygon
    implements PropertyChangeListener {
        AncestorListener ancestorListener = new AncestorListener.Stub(){

            public void ancestorMoved(IFigure ancestor) {
                ConnectionFocus.this.revalidate();
            }
        };

        ConnectionFocus() {
            this.setFill(false);
            this.setForegroundColor(ColorConstants.red);
            this.setXOR(true);
            this.setOutline(true);
        }

        public void addNotify() {
            super.addNotify();
            LinksLFConnectionEndPointEditPolicy.this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
            LinksLFConnectionEndPointEditPolicy.this.getConnection().addAncestorListener(this.ancestorListener);
        }

        protected void outlineShape(Graphics g) {
            g.setLineDash(new int[]{1, 1});
            super.outlineShape(g);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.revalidate();
        }

        public void removeNotify() {
            LinksLFConnectionEndPointEditPolicy.this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
            LinksLFConnectionEndPointEditPolicy.this.getConnection().removeAncestorListener(this.ancestorListener);
            super.removeNotify();
        }

        public void validate() {
            if (this.isValid()) {
                return;
            }
            PointList points = LinksLFConnectionEndPointEditPolicy.this.getConnection().getPoints().getCopy();
            LinksLFConnectionEndPointEditPolicy.this.getConnection().translateToAbsolute((Translatable)points);
            points = StrokePointListEx.strokeList(points, 5);
            this.translateToRelative((Translatable)points);
            this.setPoints(points);
        }
    }

    public class FeedbackHelperEx {
        private Connection connection;
        private XYAnchorEx dummyAnchor = new XYAnchorEx(new Point(10, 10));
        private boolean isMovingStartAnchor = false;

        protected Connection getConnection() {
            return this.connection;
        }

        protected boolean isMovingStartAnchor() {
            return this.isMovingStartAnchor;
        }

        public void setConnection(Connection c) {
            this.connection = c;
        }

        public void setMovingStartAnchor(boolean value) {
            this.isMovingStartAnchor = value;
        }

        protected void setAnchor(ConnectionAnchor anchor) {
            if (this.isMovingStartAnchor()) {
                this.getConnection().setSourceAnchor(anchor);
            } else {
                this.getConnection().setTargetAnchor(anchor);
            }
        }

        public void update(ConnectionAnchor anchor, Point p) {
            if (anchor != null) {
                this.setAnchor(anchor);
            } else {
                this.dummyAnchor.setLocation(p);
                this.setAnchor((ConnectionAnchor)this.dummyAnchor);
            }
        }
    }

    public static class StrokePointListEx {
        static float[] segment = new float[6];

        static PointList strokeList(PointList list, int offset) {
            GeneralPath path = new GeneralPath(1);
            Point p = list.getPoint(0);
            path.moveTo(p.x, p.y);
            int i = 1;
            while (i < list.size()) {
                p = list.getPoint(i);
                path.lineTo(p.x, p.y);
                ++i;
            }
            BasicStroke stroke = new BasicStroke(offset * 2, 2, 0, 10.0f);
            Shape stroked = stroke.createStrokedShape(path);
            Area area = new Area(stroked);
            PathIterator iter = area.getPathIterator(null, 10.0);
            PointList currentSegment = null;
            PointList result = null;
            int largestSegmentSize = 0;
            while (!iter.isDone()) {
                if (currentSegment == null) {
                    currentSegment = new PointList(list.size() * 2);
                }
                int type = iter.currentSegment(segment);
                currentSegment.addPoint(Math.round(segment[0]), Math.round(segment[1]));
                iter.next();
                if (type != 4 || currentSegment.size() <= largestSegmentSize) continue;
                result = currentSegment;
                largestSegmentSize = currentSegment.size();
                currentSegment = null;
            }
            return result;
        }
    }

    public static class XYAnchorEx
    extends XYAnchor {
        private IFigure myOwner;

        public XYAnchorEx(Point p) {
            super(p);
        }

        public IFigure getOwner() {
            if (this.myOwner == null) {
                this.myOwner = new Figure();
                this.myOwner.setBounds(new Rectangle(this.getReferencePoint().x - 1, this.getReferencePoint().y - 1, 2, 2));
            }
            return this.myOwner;
        }
    }
}

