/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.io.OutputStream;
import org.apache.wsil.WSILDocument;
import org.eclipse.wst.ws.internal.explorer.platform.actions.ImportToFileSystemAction;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;

public class ImportWSILToFileSystemAction
extends ImportToFileSystemAction {
    private WSILDocument wsilDoc_;
    private WsilElement wsilElement_;
    private NodeManager nodeManager_;

    public ImportWSILToFileSystemAction(Controller controller) {
        super(controller);
        this.nodeManager_ = controller.getWSILPerspective().getNodeManager();
    }

    public static final String getActionLink(int nodeId, int toolId, int viewId, int viewToolId) {
        return ImportToFileSystemAction.getActionLink(nodeId, toolId, viewId, viewToolId, "wsil/actions/ImportWSILToFileSystemActionJSP.jsp");
    }

    @Override
    public boolean write(OutputStream os) {
        if (this.wsilDoc_ != null) {
            return this.writeWSILDocument(os, this.wsilDoc_);
        }
        return false;
    }

    @Override
    public String getDefaultFileName() {
        String wsilFileName = this.wsilElement_.getWsilUrl();
        return wsilFileName.substring(wsilFileName.lastIndexOf(47) + 1, wsilFileName.length());
    }

    @Override
    public boolean run() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        if (selectedElement instanceof WsilElement) {
            this.wsilElement_ = (WsilElement)selectedElement;
            this.wsilDoc_ = ((WsilElement)selectedElement).getWSILDocument();
            return true;
        }
        return false;
    }

    @Override
    public final String getStatusContentVar() {
        return this.controller_.getWSILPerspective().getStatusContentVar();
    }

    @Override
    public final String getStatusContentPage() {
        return this.controller_.getWSILPerspective().getStatusContentPage();
    }
}

