/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractFujabaPlugin
extends AbstractUIPlugin {
    public boolean addImageToCache(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry(path));
        if (desc != null) {
            this.getImageRegistry().put(key, desc);
            return true;
        }
        this.logWarning("The image under '" + path + "' could not be cached. It probably does not exist.");
        return false;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (this.getImageRegistry().getDescriptor(key) == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return this.getImageRegistry().getDescriptor(key);
    }

    public Image getImage(String key) {
        if (this.getImageRegistry().get(key) == null) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.getImageRegistry().get(key);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(1, message, exception);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(2, message, exception);
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(4, message, exception);
    }

    protected abstract void log(int var1, String var2, Throwable var3);
}

