/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.console;

public enum ReportLevel {
    MINIMAL,
    TASK,
    INFO,
    DEBUG;


    public static String[] getItems() {
        String[] items = new String[ReportLevel.values().length];
        int i = 0;
        while (i < items.length) {
            items[i] = ReportLevel.values()[i].name();
            ++i;
        }
        return items;
    }

    public static ReportLevel getItem(int index) {
        int i = 0;
        while (i < ReportLevel.values().length) {
            if (index == i) {
                return ReportLevel.values()[i];
            }
            ++i;
        }
        return null;
    }

    public static int getIndex(ReportLevel reportLevel) {
        int i = 0;
        while (i < ReportLevel.values().length) {
            if (ReportLevel.values()[i].equals((Object)reportLevel)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ReportLevel getItem(String string) {
        try {
            return ReportLevel.getItem(Integer.valueOf(string));
        }
        catch (Exception e) {
            return INFO;
        }
    }

    public static String getDescription(ReportLevel reportLevel) {
        switch (reportLevel) {
            case MINIMAL: {
                return "Minimal report level. Will just output the start and end of the process, warnings and errors.";
            }
            case TASK: {
                return "Will report all message types of level 'MINIMAL' and in addition the start and end of a task.";
            }
            case INFO: {
                return "Will report all message types of level 'TASK' and in addition all runtime information of the current task.";
            }
            case DEBUG: {
                return "Will report all message types of level 'INFO' and in addition all debug messages.";
            }
        }
        return "No further description.";
    }
}

