/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.edit.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fujaba.commons.edit.commands.AbstractViewCommand;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.notation.Node;
import org.fujaba.commons.notation.NotationFactory;

public abstract class AbstractCreateNodeCommand
extends AbstractViewCommand {
    private Rectangle bounds;
    private int minWidth = 50;
    private int minHeight = 20;
    private boolean hierarchical;
    private List<Node> viewChildren;

    public AbstractCreateNodeCommand(String label, HierarchicalNode parent, boolean hierarchical, List<Node> children) {
        super(label, parent);
        this.hierarchical = hierarchical;
        this.viewChildren = children;
    }

    @Override
    public void redoView() {
        if (this.viewElement == null) {
            this.viewElement = this.hierarchical ? NotationFactory.eINSTANCE.createHierarchicalNode() : NotationFactory.eINSTANCE.createNode();
            this.getView().setPersistent(true);
            this.getView().setVisible(true);
            this.setBounds();
        }
        this.getView().setModel(this.getModel());
        this.viewParent.getNodes().add((Object)this.getView());
        if (this.hierarchical && this.viewChildren != null) {
            for (Node child : this.viewChildren) {
                child.setParent((HierarchicalNode)this.viewElement);
            }
        }
    }

    @Override
    public void undoView() {
        this.viewParent.getNodes().remove((Object)this.getView());
        this.getView().setModel(null);
        if (this.hierarchical && this.viewChildren != null) {
            for (Node child : this.viewChildren) {
                child.setParent(this.viewParent);
            }
        }
    }

    private void setBounds() {
        if (this.bounds != null) {
            if (this.getMinHeight() > this.bounds.height) {
                this.getView().setHeight(this.getMinHeight());
            } else {
                this.getView().setHeight(this.bounds.height);
            }
            if (this.getMinWidth() > this.bounds.width) {
                this.getView().setWidth(this.getMinWidth());
            } else {
                this.getView().setWidth(this.bounds.width);
            }
            this.getView().setX(this.bounds.x);
            this.getView().setY(this.bounds.y);
        }
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected int getMinHeight() {
        return this.minHeight;
    }

    protected int getMinWidth() {
        return this.minWidth;
    }

    @Override
    protected Node getView() {
        return (Node)this.viewElement;
    }

    protected void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    protected void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    protected void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }
}

