/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.edit.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.fujaba.commons.notation.DiagramElement;
import org.fujaba.commons.notation.HierarchicalNode;

public abstract class AbstractViewCommand
extends Command {
    protected HierarchicalNode viewParent;
    protected DiagramElement viewElement;
    protected EObject modelElement;
    private boolean aborted = false;

    public AbstractViewCommand(String label, HierarchicalNode viewParent) {
        super(label);
        this.viewParent = viewParent;
    }

    public boolean canExecute() {
        return this.viewParent != null;
    }

    public boolean canUndo() {
        return this.modelElement != null && this.viewElement != null;
    }

    public final void execute() {
        this.redo();
    }

    public final void redo() {
        this.redoModel();
        if (!this.isAborted()) {
            this.redoView();
        }
    }

    public final void undo() {
        if (!this.isAborted()) {
            this.undoView();
        }
        this.undoModel();
    }

    protected EObject getModel() {
        return this.modelElement;
    }

    protected DiagramElement getView() {
        return this.viewElement;
    }

    protected void abort() {
        this.aborted = true;
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    protected abstract void redoModel();

    protected abstract void redoView();

    protected abstract void undoModel();

    protected abstract void undoView();
}

