/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.edit.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;

public class SetConstraintCommand
extends Command {
    private AbstractNodeViewEditPart editpart;
    private Rectangle newBounds;
    private Rectangle oldBounds;

    public SetConstraintCommand(AbstractNodeViewEditPart part, Rectangle constraint) {
        super("set constraint");
        this.editpart = part;
        int x = part.getModel().getX();
        int y = part.getModel().getY();
        int width = part.getModel().getWidth();
        int height = part.getModel().getHeight();
        this.oldBounds = new Rectangle(x, y, width, height);
        this.newBounds = constraint;
    }

    public boolean canExecute() {
        return this.editpart != null && this.editpart.getModel() != null;
    }

    public boolean canUndo() {
        return this.oldBounds != null;
    }

    public void redo() {
        this.editpart.getModel().setX(this.newBounds.x);
        this.editpart.getModel().setY(this.newBounds.y);
        this.editpart.getModel().setWidth(this.newBounds.width);
        this.editpart.getModel().setHeight(this.newBounds.height);
    }

    public void undo() {
        this.editpart.getModel().setX(this.oldBounds.x);
        this.editpart.getModel().setY(this.oldBounds.y);
        this.editpart.getModel().setWidth(this.oldBounds.width);
        this.editpart.getModel().setHeight(this.oldBounds.height);
    }

    public void execute() {
        this.redo();
    }
}

