/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.edit.parts;

import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;
import org.fujaba.commons.figures.LineBorderedRoundedRectangleFigure;
import org.fujaba.commons.notation.Node;

public abstract class AbstractNodeEditPart
extends AbstractNodeViewEditPart
implements NodeEditPart {
    protected ConnectionAnchor anchor;

    protected IFigure createFigure() {
        this.figure = new LineBorderedRoundedRectangleFigure(10, 10);
        this.figure.setForegroundColor(ColorConstants.black);
        this.figure.setBounds(new Rectangle(5, 5, 20, 20));
        return this.figure;
    }

    protected ConnectionAnchor getAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.figure);
        }
        return this.anchor;
    }

    @Override
    public Node getModel() {
        return super.getModel();
    }

    protected List<?> getModelSourceConnections() {
        return this.getModel().getOutgoing();
    }

    protected List<?> getModelTargetConnections() {
        return this.getModel().getIncoming();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    @Override
    public void notifyChanged(Notification notification) {
        int featureID = notification.getFeatureID(Node.class);
        if (9 == featureID || 10 == featureID || 11 == featureID || 12 == featureID || 4 == featureID || 8 == featureID) {
            this.refreshVisuals();
        } else if (7 == featureID || 6 == featureID) {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    protected void refreshVisuals() {
        Rectangle rect = new Rectangle();
        if (this.getModel() != null) {
            rect.height = this.getModel().getHeight();
            rect.width = this.getModel().getWidth();
            rect.x = this.getModel().getX();
            rect.y = this.getModel().getY();
            Dimension min = this.getMinimumSize();
            if (min != null) {
                if (rect.height < min.height) {
                    rect.height = min.height;
                }
                if (rect.width < min.width) {
                    rect.width = min.width;
                }
            }
            this.getFigure().setBounds(rect);
        }
        if (this.getParent() != null && this.getParent() instanceof AbstractNodeEditPart && this.getFigure().getParent() != null) {
            ((AbstractNodeEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), rect);
        }
    }

    public Dimension getPreferredSize() {
        return this.getFigure().getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getFigure().getMinimumSize();
    }
}

