/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.fujaba.commons.editor.AbstractSimpleEditorPart;
import org.fujaba.commons.editor.NestedEObjectEditorInput;
import org.fujaba.commons.views.MultiOverviewOutlinePage;

public abstract class AbstractMultiPageEditor
extends FormEditor
implements IEditingDomainProvider,
IPersistableEditor {
    protected EditDomain editDomain;
    protected EditingDomain editingDomain;
    protected MultiOverviewOutlinePage outlinePage;
    private HashMap<EObject, NestedEObjectEditorInput> editorInputMap = new HashMap();

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected abstract void initializeEditingDomain();

    public EditDomain getEditDomain() {
        if (this.editDomain == null) {
            this.editDomain = new DefaultEditDomain((IEditorPart)this);
        }
        return this.editDomain;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    protected MultiOverviewOutlinePage getOverviewOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new MultiOverviewOutlinePage();
        }
        return this.outlinePage;
    }

    protected void updateContentOutline(IEditorPart editor) {
        if (this.outlinePage != null) {
            if (editor == null) {
                this.outlinePage.setDefaultPageActive();
                return;
            }
            IContentOutlinePage page = (IContentOutlinePage)editor.getAdapter(IContentOutlinePage.class);
            if (page != null) {
                this.outlinePage.setActivePage(page);
            } else {
                this.outlinePage.setDefaultPageActive();
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.updateContentOutline(this.getActiveEditor());
    }

    public int findEditor(IEditorInput input) {
        int size = this.getPageCount();
        int i = 0;
        while (i < size) {
            try {
                IEditorPart e = this.getEditor(i);
                if (e != null && e.getEditorInput().equals(input)) {
                    return i;
                }
            }
            catch (IllegalArgumentException ex) {
                Object var4_4 = null;
            }
            ++i;
        }
        return -1;
    }

    protected void setTabsToCloseable(int pageIndex, AbstractSimpleEditorPart page) {
        CTabItem item = ((CTabFolder)this.getContainer()).getItem(pageIndex);
        Control parent = item.getControl();
        item.dispose();
        item = this.createItem(parent);
        item.setData((Object)page);
        page.setCTabItem(item);
    }

    protected CTabItem createItem(Control control) {
        CTabItem item = new CTabItem((CTabFolder)this.getContainer(), 64);
        item.setControl(control);
        return item;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    protected IEditorInput provideEditorInput(EObject nestedEditorInput) {
        if (this.editorInputMap.get(nestedEditorInput) != null) {
            return this.editorInputMap.get(nestedEditorInput);
        }
        NestedEObjectEditorInput input = new NestedEObjectEditorInput(nestedEditorInput);
        this.editorInputMap.put(nestedEditorInput, input);
        return input;
    }
}

