/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.editor.AbstractMultiPageEditor;

public abstract class AbstractPersistableModelViewMultiPageEditor
extends AbstractMultiPageEditor {
    protected Resource diagramResource;
    protected Resource modelResource;

    public Resource getDiagramResource() {
        return this.diagramResource;
    }

    public Resource getModelResource() {
        return this.modelResource;
    }

    public void doSave(IProgressMonitor monitor) {
        this.performSaveAs(this.getEditorInputFile());
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(this.getEditorInputFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                AbstractPersistableModelViewMultiPageEditor.this.performSaveAs(file);
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (InvocationTargetException e) {
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), e);
        }
        this.getCommandStack().markSaveLocation();
    }

    protected IFile getEditorInputFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)super.getEditorInput()).getFile();
        }
        return null;
    }

    protected void performSaveAs(IFile diagramFile) {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        try {
            this.modelResource.save(resourceSet.getLoadOptions());
            this.diagramResource.save(resourceSet.getLoadOptions());
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save Error", (String)("During saving of the latest changes an exception occurred: " + e.getMessage() + "\nsee Error Log for Stacktrace"));
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), e);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }
}

