/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractSinglePageEditor
extends EditorPart {
    private ISelectionListener selectionListener;
    private CommandStackListener commandStackListener;
    private boolean isDirty;
    private ActionRegistry actionRegistry;
    private List<String> editorActionIDs = new ArrayList<String>();
    private List<String> commandStackActionIDs = new ArrayList<String>();
    private boolean disposed = false;
    private List<String> editPartActionIDs = new ArrayList<String>();

    protected void addEditPartAction(SelectionAction action) {
        this.addAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void addCommandStackAction(StackAction action) {
        this.addAction((IAction)action);
        this.commandStackActionIDs.add(action.getId());
    }

    protected void addEditorAction(EditorPartAction action) {
        this.addAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    private void updateActions(List<String> actionIDs) {
        Iterator<String> ids = actionIDs.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction((Object)ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected void updateEditorActions() {
        this.updateActions(this.editorActionIDs);
    }

    protected void updateEditPartActions() {
        this.updateActions(this.editPartActionIDs);
    }

    protected void updateCommandStackActions() {
        this.updateActions(this.commandStackActionIDs);
    }

    public ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected ISelectionListener createSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                AbstractSinglePageEditor.this.updateEditPartActions();
            }
        };
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(listener);
    }

    protected CommandStackListener getCommandStackListener() {
        if (this.commandStackListener == null) {
            this.commandStackListener = this.createCommandStackListener();
        }
        return this.commandStackListener;
    }

    protected CommandStackListener createCommandStackListener() {
        return new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                AbstractSinglePageEditor.this.updateCommandStackActions();
                AbstractSinglePageEditor.this.setDirty(AbstractSinglePageEditor.this.getCommandStack().isDirty());
            }
        };
    }

    public abstract CommandStack getCommandStack();

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.addSelectionListener(this.getSelectionListener());
        this.getCommandStack().addCommandStackListener(this.getCommandStackListener());
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.getActionRegistry().dispose();
        this.removeSelectionListener(this.getSelectionListener());
        this.getCommandStack().removeCommandStackListener(this.getCommandStackListener());
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == CommandStack.class) {
            return this.getCommandStack();
        }
        return super.getAdapter(adapter);
    }

    protected void firePropertyChange(int propertyID) {
        super.firePropertyChange(propertyID);
        this.updateActions(this.editorActionIDs);
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

