/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;

public class DefaultContextMenuProvider
extends ContextMenuProvider {
    public static final String GROUP_FUJABA = "FUJABA";
    private ActionRegistry actionRegistry;
    private HashMap<String, String> actionGroupMappings;
    private static final String[] defaultExclusionList = new String[]{"replaceWithMenu", "compareWithMenu", "ValidationAction", "team.main", "org.eclipse.jst.ws.atk.ui.webservice.category.popupMenu", "org.eclipse.tptp.platform.analysis.core.ui.internal.actions.MultiAnalysisActionDelegate", "org.eclipse.debug.ui.contextualLaunch.run.submenu", "org.eclipse.debug.ui.contextualLaunch.debug.submenu", "org.eclipse.debug.ui.contextualLaunch.profile.submenu", "org.eclipse.mylyn.resources.ui.ui.interest.remove.element"};
    private HashSet<String> exclusionSet;

    public DefaultContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.actionRegistry = registry;
        this.actionGroupMappings = new HashMap();
        this.exclusionSet = new HashSet();
        this.initActionGroupMappings();
        this.addDefaultExclusions();
    }

    public void addActionToGroup(String actionID, String groupID) {
        this.actionGroupMappings.put(actionID, groupID);
    }

    protected void initActionGroupMappings() {
        this.addActionToGroup(ActionFactory.DELETE.getId(), "org.eclipse.gef.group.edit");
        this.addActionToGroup(ActionFactory.UNDO.getId(), "org.eclipse.gef.group.undo");
        this.addActionToGroup(ActionFactory.REDO.getId(), "org.eclipse.gef.group.undo");
        this.addActionToGroup(ActionFactory.SAVE.getId(), "org.eclipse.gef.group.save");
    }

    protected boolean allowItem(IContributionItem item) {
        if (item.getId() != null && this.exclusionSet.contains(item.getId()) || !item.isEnabled()) {
            item.setVisible(false);
        }
        return super.allowItem(item);
    }

    protected void addDefaultExclusions() {
        String[] stringArray = defaultExclusionList;
        int n = defaultExclusionList.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.exclusionSet.add(item);
            ++n2;
        }
    }

    public void buildContextMenu(IMenuManager menu) {
        this.getViewer().flush();
        menu.add((IContributionItem)new Separator(GROUP_FUJABA));
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        for (String actionId : this.actionGroupMappings.keySet()) {
            IAction action = this.actionRegistry.getAction((Object)actionId);
            if (action == null || !action.isEnabled()) continue;
            menu.appendToGroup(this.actionGroupMappings.get(actionId), action);
        }
    }
}

