/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor.overviewpage;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fujaba.commons.editor.AbstractMultiPageEditor;

public class TextSectionPart
extends SectionPart
implements Adapter {
    private AbstractMultiPageEditor editor;
    private EObject element;
    private EStructuralFeature feature;
    private Text text;

    public TextSectionPart(AbstractMultiPageEditor editor, Composite parent, FormToolkit toolkit, String label, EStructuralFeature feature) {
        super(toolkit.createSection(parent, 322));
        this.editor = editor;
        this.feature = feature;
        this.getSection().setText(label);
        Composite nameComposite = toolkit.createComposite((Composite)this.getSection());
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        this.text = toolkit.createText(nameComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text);
        this.getSection().setClient((Control)nameComposite);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    TextSectionPart.this.refresh();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextSectionPart.this.markDirty();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TextSectionPart.this.isDirty()) {
                    TextSectionPart.this.commit(false);
                }
            }
        });
    }

    public void commit(boolean onSave) {
        EditingDomain ed = this.editor.getEditingDomain();
        CommandStack cs = ed.getCommandStack();
        cs.execute(SetCommand.create((EditingDomain)ed, (Object)this.element, (Object)this.feature, (Object)this.text.getText()));
        super.commit(onSave);
    }

    public void refresh() {
        if (this.element != null) {
            Object textFeature = this.element.eGet(this.feature);
            if (textFeature != null && textFeature instanceof String) {
                this.text.setText((String)textFeature);
            } else {
                this.text.setText("");
            }
        }
        super.refresh();
    }

    public boolean setFormInput(Object input) {
        if (this.element != null && this.element != input) {
            this.element.eAdapters().remove((Object)this);
        }
        if (input instanceof EObject) {
            this.element = (EObject)input;
            this.element.eAdapters().add((Object)this);
            this.safeRefresh();
            return true;
        }
        return false;
    }

    private void safeRefresh() {
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TextSectionPart.this.refresh();
                }
            });
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        this.safeRefresh();
    }

    public void setTarget(Notifier newTarget) {
    }
}

