/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class AttachmentDecoratorFigure
extends FreeformLayer
implements PropertyChangeListener {
    private int offsetX = 0;
    private int offsetY = 0;
    private float referenceX = 0.0f;
    private float referenceY = 0.0f;
    private float alignmentX = 0.0f;
    private float alignmentY = 0.0f;
    private IFigure target = null;
    private boolean parentManagementAutomatic = true;
    private boolean overlay = false;

    public AttachmentDecoratorFigure(IFigure target) {
        this(target, 0.0f, 0.0f, 0, 0);
    }

    public AttachmentDecoratorFigure(IFigure target, int offsetX, int offsetY) {
        this(target, 0.0f, 0.0f, offsetX, offsetY);
    }

    public AttachmentDecoratorFigure(IFigure target, float referenceX, float referenceY) {
        this(target, referenceX, referenceY, 0, 0);
    }

    public AttachmentDecoratorFigure(IFigure target, float referenceX, float referenceY, int offsetX, int offsetY) {
        this.setTarget(target);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
        this.setReferenceX(referenceX);
        this.setReferenceY(referenceY);
        this.setOpaque(true);
    }

    public AttachmentDecoratorFigure(IFigure target, int side, int offsetX, int offsetY) {
        this(target, 0.0f, 0.0f, offsetX, offsetY);
        this.setSide(side);
    }

    public AttachmentDecoratorFigure(IFigure target, int side, int alignment, int offsetX, int offsetY) {
        this(target, 0.0f, 0.0f, offsetX, offsetY);
        this.setSide(side);
        this.setAlignment(alignment);
    }

    public void disconnect() {
        if (this.target != null) {
            this.target.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.target = null;
    }

    public void removeDecorator() {
        this.setTarget(null);
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public IFigure getTarget() {
        return this.target;
    }

    public boolean isParentManagementAutomatic() {
        return this.parentManagementAutomatic;
    }

    public void setParentManagementAutomatic(boolean parentManagementAutomatic) {
        this.parentManagementAutomatic = parentManagementAutomatic;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.updateParent();
    }

    private void updateParent() {
        if (this.isParentManagementAutomatic()) {
            if (this.getTarget() == null) {
                if (this.getParent() != null) {
                    this.getParent().remove((IFigure)this);
                }
            } else if (this.getParent() != this.getTarget().getParent()) {
                if (this.getParent() != null) {
                    this.getParent().remove((IFigure)this);
                }
                if (this.target.getParent() != null) {
                    if (this.isOverlay()) {
                        this.target.getParent().add((IFigure)this);
                    } else {
                        this.target.getParent().add((IFigure)this, 0);
                    }
                }
            }
        }
    }

    public void setTarget(IFigure target) {
        if (target == this) {
            throw new IllegalArgumentException("Target must not be the decorator itself.");
        }
        if (this.target != target) {
            if (this.target != null) {
                this.target.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.target = target;
            if (this.target != null) {
                this.target.addPropertyChangeListener("parent", (PropertyChangeListener)this);
            }
        }
        this.updateParent();
    }

    public void setSide(int side) {
        if (side == 9) {
            this.setReference(0.0f, 0.0f);
        } else if (side == 1) {
            this.setReference(0.5f, 0.0f);
        } else if (side == 17) {
            this.setReference(1.0f, 0.0f);
        } else if (side == 16) {
            this.setReference(1.0f, 0.5f);
        } else if (side == 20) {
            this.setReference(1.0f, 1.0f);
        } else if (side == 4) {
            this.setReference(0.5f, 1.0f);
        } else if (side == 12) {
            this.setReference(0.0f, 1.0f);
        } else if (side == 8) {
            this.setReference(0.0f, 0.5f);
        }
    }

    public void setAlignment(int side) {
        if (side == 9) {
            this.setAlignment(0.0f, 0.0f);
        } else if (side == 1) {
            this.setAlignment(0.5f, 0.0f);
        } else if (side == 17) {
            this.setAlignment(1.0f, 0.0f);
        } else if (side == 16) {
            this.setAlignment(1.0f, 0.5f);
        } else if (side == 20) {
            this.setAlignment(1.0f, 1.0f);
        } else if (side == 4) {
            this.setAlignment(0.5f, 1.0f);
        } else if (side == 12) {
            this.setAlignment(0.0f, 1.0f);
        } else if (side == 8) {
            this.setAlignment(0.0f, 0.5f);
        }
    }

    public void setOffset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public void setReference(float referenceX, float referenceY) {
        this.referenceX = referenceX;
        this.referenceY = referenceY;
    }

    public float getReferenceX() {
        return this.referenceX;
    }

    public void setReferenceX(float referenceX) {
        this.referenceX = referenceX;
    }

    public float getReferenceY() {
        return this.referenceY;
    }

    public void setReferenceY(float referenceY) {
        this.referenceY = referenceY;
    }

    public void setAlignment(float connectorX, float connectorY) {
        this.alignmentX = connectorX;
        this.alignmentY = connectorY;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentX(float connectorX) {
        this.alignmentX = connectorX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public void setAlignmentY(float connectorY) {
        this.alignmentY = connectorY;
    }

    public Rectangle getBounds() {
        if (this.getTarget() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle targetBounds = this.getTarget().getBounds().getCopy();
        Rectangle decoratorBounds = super.getFreeformExtent().getCopy();
        decoratorBounds.setLocation(targetBounds.getLocation());
        int relativeX = Math.round(this.referenceX * (float)targetBounds.width);
        int relativeY = Math.round(this.referenceY * (float)targetBounds.height);
        decoratorBounds.translate(relativeX, relativeY);
        int innerX = Math.round(this.alignmentX * (float)decoratorBounds.width);
        int innerY = Math.round(this.alignmentY * (float)decoratorBounds.height);
        decoratorBounds.translate(-innerX, -innerY);
        decoratorBounds.translate(this.offsetX, this.offsetY);
        return decoratorBounds;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

