/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.ILineBorder;
import org.fujaba.commons.figures.LineBorderedFigure;

public abstract class LineBorderedGenericFigure
extends LineBorderedFigure {
    private Color color = ColorConstants.black;
    private int width = 1;
    private int lineStyle = 1;

    protected boolean enableBorderStyle(Graphics graphics) {
        graphics.pushState();
        try {
            graphics.setForegroundColor(this.color);
            graphics.setLineStyle(this.lineStyle);
            graphics.setLineWidth(this.width);
            return true;
        }
        catch (Exception e) {
            graphics.popState();
            return false;
        }
    }

    protected void disableBorderStyle(Graphics graphics) {
        graphics.popState();
    }

    @Override
    public ILineBorder getBorder() {
        return null;
    }

    @Override
    public void setBorder(Border border) {
        throw new UnsupportedOperationException("LineBorderedGenericFigure acts as its own border.");
    }

    @Override
    public int getBorderLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setBorderLineStyle(int style) {
        if (this.lineStyle != style) {
            this.lineStyle = style;
            this.repaint();
        }
    }

    @Override
    public int getBorderWidth() {
        return this.width;
    }

    @Override
    public void setBorderWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.repaint();
        }
    }

    @Override
    public Color getBorderColor() {
        return this.color;
    }

    @Override
    public void setBorderColor(Color color) {
        if (this.color != color) {
            this.color = color;
            this.repaint();
        }
    }
}

