/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.LineBorderedFigure;
import org.fujaba.commons.figures.LineFigure;
import org.fujaba.commons.figures.RectangleBorder;

public abstract class LineBorderedRectangleWithCompartmentsFigure
extends LineBorderedFigure {
    private LinkedHashMap<String, IFigure> compartments = new LinkedHashMap();
    private HashMap<String, LineFigure> separators = new HashMap();

    public LineBorderedRectangleWithCompartmentsFigure() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setHorizontal(false);
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(true);
        this.setBorder(new RectangleBorder());
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
    }

    @Override
    public void setBorderLineStyle(int style) {
        super.setBorderLineStyle(style);
        Iterator<LineFigure> its = this.separators.values().iterator();
        while (its.hasNext()) {
            its.next().setLineStyle(style);
        }
    }

    @Override
    public void setBorderWidth(int width) {
        super.setBorderWidth(width);
        Iterator<LineFigure> its = this.separators.values().iterator();
        while (its.hasNext()) {
            its.next().setWidth(width);
        }
    }

    @Override
    public void setBorderColor(Color color) {
        super.setBorderColor(color);
        Iterator<LineFigure> its = this.separators.values().iterator();
        while (its.hasNext()) {
            its.next().setColor(color);
        }
    }

    protected void addCompartment(String compartmentKey, int followingLineStyle, int followingLineWidth) {
        if (this.compartments.containsKey(compartmentKey)) {
            throw new UnsupportedOperationException("A compartment with the given key already exists.");
        }
        if (followingLineStyle != 0 && followingLineWidth < 1) {
            throw new IllegalArgumentException("The line width must be at least 1.");
        }
        Figure compartment = new Figure();
        compartment.setOpaque(true);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setHorizontal(false);
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(true);
        compartment.setLayoutManager((LayoutManager)layout);
        this.compartments.put(compartmentKey, (IFigure)compartment);
        this.add((IFigure)compartment);
        if (followingLineStyle != 0) {
            LineFigure separator = new LineFigure(followingLineWidth, followingLineStyle, 256);
            separator.setForegroundColor(ColorConstants.black);
            this.separators.put(compartmentKey, separator);
            this.add((IFigure)separator);
        }
    }

    protected void addCompartment(String compartmentKey) {
        this.addCompartment(compartmentKey, 1, 1);
    }

    public IFigure getCompartment(String compartmentKey) {
        return this.compartments.get(compartmentKey);
    }

    protected void addFigureToCompartment(String compartmentKey, IFigure figure) {
        this.addFigureToCompartment(compartmentKey, figure, -1);
    }

    protected void addFigureToCompartment(String compartmentKey, IFigure figure, int index) {
        if (!this.compartments.containsKey(compartmentKey)) {
            throw new IllegalArgumentException("There is no compartment with the given key.");
        }
        IFigure compartment = this.compartments.get(compartmentKey);
        if (!compartment.getChildren().contains(figure)) {
            compartment.add(figure, index);
        }
        this.revalidateSeparators();
    }

    protected void removeFigureFromCompartment(String compartmentKey, IFigure figure) {
        if (!this.compartments.containsKey(compartmentKey)) {
            throw new IllegalArgumentException("There is no compartment with the given key.");
        }
        IFigure compartment = this.compartments.get(compartmentKey);
        if (compartment.getChildren().contains(figure)) {
            compartment.remove(figure);
        }
        this.revalidateSeparators();
    }

    private void revalidateSeparators() {
        List children = this.getChildren();
        for (String key : this.separators.keySet()) {
            LineFigure separator = this.separators.get(key);
            if (!children.contains((Object)separator)) continue;
            this.remove((IFigure)separator);
        }
        LineFigure currentSeparator = null;
        int index = -1;
        for (String compartmentKey : this.compartments.keySet()) {
            IFigure compartment = this.compartments.get(compartmentKey);
            if (compartment.getChildren().size() <= 0) continue;
            children = this.getChildren();
            if (currentSeparator != null && !children.contains((Object)currentSeparator)) {
                this.add((IFigure)currentSeparator, index);
            }
            currentSeparator = this.separators.get(compartmentKey);
            index = children.indexOf(compartment) + 1;
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Iterator<String> figureIter = this.compartments.keySet().iterator();
        Dimension dim = super.getPreferredSize(wHint, hHint);
        while (figureIter.hasNext()) {
            Dimension subDim;
            IFigure figure = this.compartments.get(figureIter.next());
            if (figure == null || dim.contains(subDim = figure.getPreferredSize())) continue;
            dim = dim.getUnioned(subDim);
        }
        return dim;
    }
}

