/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.AbstractLineBorder;

public class PartialRectangleBorder
extends AbstractLineBorder {
    private boolean top = true;
    private boolean left = true;
    private boolean bottom = true;
    private boolean right = true;

    public PartialRectangleBorder(boolean top, boolean left, boolean bottom, boolean right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public PartialRectangleBorder(Color color, int width, boolean top, boolean left, boolean bottom, boolean right) {
        this(top, left, bottom, right);
        this.setColor(color);
        this.setWidth(width);
    }

    public PartialRectangleBorder() {
    }

    public PartialRectangleBorder(int width) {
        this(null, width);
    }

    public PartialRectangleBorder(Color color) {
        this(color, 1);
    }

    public PartialRectangleBorder(Color color, int width) {
        this.setColor(color);
        this.setWidth(width);
    }

    public PartialRectangleBorder(Color color, int width, int lineStyle) {
        this.setColor(color);
        this.setWidth(width);
        this.setLineStyle(lineStyle);
    }

    public void setVisible(int sides) {
        this.top = false;
        this.left = false;
        this.bottom = false;
        this.right = false;
        this.show(sides);
    }

    public void show(int sides) {
        if ((sides & 1) != 0) {
            this.top = true;
        }
        if ((sides & 8) != 0) {
            this.left = true;
        }
        if ((sides & 4) != 0) {
            this.bottom = true;
        }
        if ((sides & 0x10) != 0) {
            this.right = true;
        }
    }

    public void hide(int sides) {
        if ((sides & 1) != 0) {
            this.top = false;
        }
        if ((sides & 8) != 0) {
            this.left = false;
        }
        if ((sides & 4) != 0) {
            this.bottom = false;
        }
        if ((sides & 0x10) != 0) {
            this.right = false;
        }
    }

    public Insets getInsets(IFigure figure) {
        int width = this.getWidth();
        return new Insets(this.top ? width : 0, this.left ? width : 0, this.bottom ? width : 0, this.right ? width : 0);
    }

    @Override
    public void paintBorder(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(PartialRectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            if (this.left && this.right) {
                --PartialRectangleBorder.tempRect.width;
            }
            if (this.top && this.bottom) {
                --PartialRectangleBorder.tempRect.height;
            }
        }
        int delta = this.getWidth() / 2;
        if (this.top) {
            PartialRectangleBorder.tempRect.y += delta;
            PartialRectangleBorder.tempRect.width -= delta;
        }
        if (this.left) {
            PartialRectangleBorder.tempRect.x += delta;
            PartialRectangleBorder.tempRect.height -= delta;
        }
        if (this.bottom) {
            PartialRectangleBorder.tempRect.height -= delta;
        }
        if (this.right) {
            PartialRectangleBorder.tempRect.width -= delta;
        }
        if (this.top) {
            graphics.drawLine(PartialRectangleBorder.tempRect.x, PartialRectangleBorder.tempRect.y, PartialRectangleBorder.tempRect.x + PartialRectangleBorder.tempRect.width, PartialRectangleBorder.tempRect.y);
        }
        if (this.left) {
            graphics.drawLine(PartialRectangleBorder.tempRect.x, PartialRectangleBorder.tempRect.y, PartialRectangleBorder.tempRect.x, PartialRectangleBorder.tempRect.y + PartialRectangleBorder.tempRect.height);
        }
        if (this.bottom) {
            graphics.drawLine(PartialRectangleBorder.tempRect.x, PartialRectangleBorder.tempRect.y + PartialRectangleBorder.tempRect.height, PartialRectangleBorder.tempRect.x + PartialRectangleBorder.tempRect.width, PartialRectangleBorder.tempRect.y + PartialRectangleBorder.tempRect.height);
        }
        if (this.right) {
            graphics.drawLine(PartialRectangleBorder.tempRect.x + PartialRectangleBorder.tempRect.width, PartialRectangleBorder.tempRect.y, PartialRectangleBorder.tempRect.x + PartialRectangleBorder.tempRect.width, PartialRectangleBorder.tempRect.y + PartialRectangleBorder.tempRect.height);
        }
    }
}

