/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.AbstractLineBorder;

public class RoundedRectangleBorder
extends AbstractLineBorder {
    public static final int ARC_RELATIVE = -1;
    private int arcX = -1;
    private int arcY = -1;
    private float relativeArcX = 0.2f;
    private float relativeArcY = 0.2f;
    private boolean symmetrical = true;

    public RoundedRectangleBorder() {
    }

    public RoundedRectangleBorder(int arcX, int arcY) {
        this.setArcX(arcX);
        this.setArcY(arcY);
    }

    public RoundedRectangleBorder(float relativeArcX, float relativeArcY) {
        this.setRelativeArcX(relativeArcX);
        this.setRelativeArcY(relativeArcY);
    }

    public RoundedRectangleBorder(int width) {
        this(null, width);
    }

    public RoundedRectangleBorder(Color color) {
        this(color, 1);
    }

    public RoundedRectangleBorder(Color color, int width) {
        this.setColor(color);
        this.setWidth(width);
    }

    public RoundedRectangleBorder(Color color, int width, int lineStyle) {
        this.setColor(color);
        this.setWidth(width);
        this.setLineStyle(lineStyle);
    }

    public void setRelativeArc(float relativeArc) {
        this.setRelativeArcX(relativeArc);
        this.setRelativeArcY(relativeArc);
    }

    public float getRelativeArcX() {
        return this.relativeArcX;
    }

    public void setRelativeArcX(float relativeArcX) {
        this.relativeArcX = relativeArcX;
        this.arcX = -1;
    }

    public float getRelativeArcY() {
        return this.relativeArcY;
    }

    public void setRelativeArcY(float relativeArcY) {
        this.relativeArcY = relativeArcY;
        this.arcY = -1;
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
    }

    public void setArc(int arc) {
        this.setArcX(arc);
        this.setArcY(arc);
    }

    public int getArcX() {
        return this.arcX;
    }

    public void setArcX(int arcX) {
        this.arcX = arcX;
        this.symmetrical = false;
    }

    public int getArcY() {
        return this.arcY;
    }

    public void setArcY(int arcY) {
        this.arcY = arcY;
        this.symmetrical = false;
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth());
    }

    @Override
    public void paintBorder(IFigure figure, Graphics graphics, Insets insets) {
        int drawArcY;
        tempRect.setBounds(RoundedRectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoundedRectangleBorder.tempRect.width;
            --RoundedRectangleBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        int drawArcX = this.getArcX();
        if (drawArcX == -1) {
            drawArcX = Math.round(this.getRelativeArcX() * (float)figure.getBounds().width);
        }
        if ((drawArcY = this.getArcY()) == -1) {
            drawArcY = Math.round(this.getRelativeArcY() * (float)figure.getBounds().width);
        }
        if (this.isSymmetrical()) {
            drawArcY = drawArcX = Math.min(drawArcX, drawArcY);
        }
        graphics.drawRoundRectangle(tempRect, drawArcX, drawArcY);
    }
}

