/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fujaba.commons.figures.AttachmentDecoratorFigure;

public class ShadowDecoratorFigure
extends AttachmentDecoratorFigure {
    public static final int DEFAULT_OFFSET = 5;
    public static final int DEFAULT_DELTA = 0;
    private int delta = 0;
    private IFigure shadow = null;

    public ShadowDecoratorFigure(IFigure shadowCaster) {
        this(shadowCaster, 5, -5, 0);
    }

    public ShadowDecoratorFigure(IFigure shadowCaster, int offsetX, int offsetY) {
        this(shadowCaster, offsetX, offsetY, 0);
    }

    public ShadowDecoratorFigure(IFigure shadowCaster, int offsetX, int offsetY, int delta) {
        super(shadowCaster, offsetX, offsetY);
        this.delta = delta;
        this.setOpaque(false);
    }

    public ShadowDecoratorFigure(IFigure shadowCaster, IFigure shadow, int offsetX, int offsetY) {
        this(shadowCaster, shadow, offsetX, offsetY, 0);
    }

    public ShadowDecoratorFigure(IFigure shadowCaster, IFigure shadow, int offsetX, int offsetY, int delta) {
        super(shadowCaster, offsetX, offsetY);
        this.delta = delta;
        this.shadow = shadow;
    }

    @Override
    public Rectangle getBounds() {
        if (this.getTarget() != null) {
            Rectangle shadowBounds = this.getTarget().getBounds().getCopy();
            shadowBounds.translate(this.getOffsetX(), this.getOffsetY());
            shadowBounds.expand(this.delta, this.delta);
            return shadowBounds;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.getShadow() == null) {
            graphics.pushState();
            try {
                graphics.setForegroundColor(this.getTarget().getForegroundColor());
                graphics.setBackgroundColor(this.getTarget().getBackgroundColor());
                this.paintFigure(graphics);
                if (this.getTarget().getBorder() == null) return;
                this.getTarget().getBorder().paint((IFigure)this, graphics, NO_INSETS);
                return;
            }
            finally {
                graphics.popState();
            }
        } else {
            this.getShadow().setBounds(this.getBounds());
            this.getShadow().paint(graphics);
        }
    }

    public int getDelta() {
        return this.delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public IFigure getShadow() {
        return this.shadow;
    }

    public void setShadow(IFigure shadow) {
        this.shadow = shadow;
    }
}

