/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.fujaba.commons.figures.LineBorderedFigure;
import org.fujaba.commons.figures.RectangleBorder;
import org.fujaba.commons.figures.UMLFragmentLabelFigure;

public class UMLFragmentFigure
extends LineBorderedFigure {
    private UMLFragmentLabelFigure label;

    public UMLFragmentFigure() {
        this("");
    }

    public UMLFragmentFigure(String name) {
        this.setBorder(new RectangleBorder(ColorConstants.black, 1));
        this.label = new UMLFragmentLabelFigure(name);
        this.add((IFigure)this.label);
        this.setBorderColor(ColorConstants.black);
        this.setBackgroundColor(ColorConstants.white);
        this.setOpaque(false);
    }

    public UMLFragmentLabelFigure getLabel() {
        return this.label;
    }

    public void setText(String text) {
        this.label.setText(0, text);
    }

    public void setIcon(Image image) {
        this.label.setIcon(0, image);
    }

    @Override
    public void setBorderColor(Color color) {
        super.setBorderColor(color);
        if (this.label != null) {
            this.label.setBorderColor(color);
        }
    }

    public void setBorderLineStle(int lineStyle) {
        super.setBorderLineStyle(lineStyle);
        if (this.label != null) {
            this.label.setBorderLineStyle(lineStyle);
        }
    }

    @Override
    public void setBorderWidth(int width) {
        super.setBorderWidth(width);
        if (this.label != null) {
            this.label.setBorderWidth(width);
        }
    }

    public Rectangle getClientArea(Rectangle rect) {
        Rectangle result = super.getClientArea(rect);
        result.y += this.label.getPreferredSize().height;
        return result;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.label.setSize(this.label.getPreferredSize());
        this.label.setLocation(new Point(this.getClientArea().x, this.getClientArea().y - this.label.getSize().height));
        this.label.paint(graphics);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension fragmentPreferred = super.getPreferredSize(wHint, hHint);
        Dimension labelPreferred = this.label.getPreferredSize();
        Dimension preferred = new Dimension();
        preferred.height = Math.max(fragmentPreferred.height, labelPreferred.height);
        preferred.width = Math.max(fragmentPreferred.width, labelPreferred.width);
        return preferred;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension fragmentMinimum = super.getMinimumSize(wHint, hHint);
        Dimension labelPreferred = this.label.getPreferredSize();
        Dimension minimum = new Dimension();
        minimum.height = Math.max(fragmentMinimum.height, labelPreferred.height);
        minimum.width = Math.max(fragmentMinimum.width, labelPreferred.width);
        return minimum;
    }
}

