/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.figures.LabelFigure;
import org.fujaba.commons.figures.LineBorderedGenericFigure;

public class UMLFragmentLabelFigure
extends LineBorderedGenericFigure {
    List<LabelFigure> labels = null;

    public UMLFragmentLabelFigure() {
        this.setLayoutManager(new FragmentLabelFigureLayoutManager());
        this.setBackgroundColor(ColorConstants.white);
        this.setOpaque(true);
        this.labels = new ArrayList<LabelFigure>();
    }

    public UMLFragmentLabelFigure(String text) {
        this();
        LabelFigure textLabel = new LabelFigure(text, Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
        this.addLabel(textLabel);
    }

    public UMLFragmentLabelFigure(String prefix, String text) {
        this();
        LabelFigure boldLabel = new LabelFigure(prefix, Commons4EclipseFonts.getFont("org.fujaba.commons.FONT_BOLD"));
        this.addLabel(boldLabel);
        LabelFigure textLabel = new LabelFigure(text, Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
        this.addLabel(textLabel);
    }

    public void setPrefix(String prefix) {
        if (this.labels.size() <= 0) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: Cannot set prefix (first sublabel) as there are no sublabels.");
        }
        this.labels.get(0).setText(prefix);
    }

    public void setText(String text) {
        if (this.labels.size() <= 1) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: Cannot set text (second sublabel) as there is no second sublabel.");
        }
        this.labels.get(1).setText(text);
    }

    public void addLabel() {
        LabelFigure label = new LabelFigure();
        this.labels.add(label);
        this.add((IFigure)label);
    }

    public void addLabel(LabelFigure figure) {
        this.labels.add(figure);
        this.add((IFigure)figure);
    }

    public void addLabel(int index) {
        if (index >= this.labels.size()) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: No such index.");
        }
        LabelFigure label = new LabelFigure();
        this.labels.add(index, label);
        this.add((IFigure)label, index);
    }

    public void addLabel(int index, LabelFigure figure) {
        if (index >= this.labels.size()) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: No such index.");
        }
        this.labels.add(index, figure);
        this.add((IFigure)figure, index);
    }

    public int sizeOfLabels() {
        return this.labels.size();
    }

    public LabelFigure getLabel(int index) {
        if (index >= this.labels.size()) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: No such index.");
        }
        return this.labels.get(index);
    }

    public void removeLabel(int index) {
        if (index >= this.labels.size()) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: No such index.");
        }
        this.remove((IFigure)this.labels.get(index));
        this.labels.remove(index);
    }

    public boolean removeLabel(LabelFigure label) {
        this.remove((IFigure)label);
        return this.labels.remove((Object)label);
    }

    public void removeAllLabels() {
        this.labels.clear();
        this.removeAll();
    }

    public void setText(int index, String text) {
        if (index >= this.labels.size()) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: No such index.");
        }
        this.labels.get(index).setText(text);
    }

    public void setIcon(int index, Image image) {
        if (index >= this.labels.size()) {
            throw new IllegalArgumentException("UMLFragmentLabelFigure: No such index.");
        }
        this.labels.get(index).setIcon(image);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        Point p1 = new Point(bounds.x, bounds.y + bounds.height - 1);
        Point p2 = new Point(bounds.x + bounds.width - 6, bounds.y + bounds.height - 1);
        Point p3 = new Point(bounds.x + bounds.width - 1, bounds.y + bounds.height - 6);
        Point p4 = new Point(bounds.x + bounds.width - 1, bounds.y);
        graphics.pushState();
        try {
            int[] points = new int[]{p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y, bounds.x, bounds.y};
            if (this.isOpaque()) {
                if (this.getBackgroundColor() != null) {
                    graphics.setBackgroundColor(this.getBackgroundColor());
                }
                graphics.fillPolygon(points);
            }
            if (this.enableBorderStyle(graphics)) {
                graphics.drawLine(p1, p2);
                graphics.drawLine(p2, p3);
                graphics.drawLine(p3, p4);
                this.disableBorderStyle(graphics);
            }
        }
        finally {
            graphics.popState();
        }
    }

    class FragmentLabelFigureLayoutManager
    implements LayoutManager {
        private static final int OFFSET_LEFT_X = 3;
        private static final int OFFSET_TOP_Y = 2;
        private static final int OFFSET_RIGHT_X = 7;
        private static final int OFFSET_BOTTOM_Y = 4;

        FragmentLabelFigureLayoutManager() {
        }

        public Object getConstraint(IFigure child) {
            return null;
        }

        public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
            return this.getPreferredSize(container, wHint, hHint);
        }

        public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
            Dimension result = new Dimension(7, 4);
            Iterator<LabelFigure> itl = UMLFragmentLabelFigure.this.labels.iterator();
            while (itl.hasNext()) {
                Dimension labelDimensions = itl.next().getPreferredSize();
                result.width += labelDimensions.width;
                result.height = Math.max(result.height, labelDimensions.height + 4);
            }
            return result;
        }

        public void invalidate() {
        }

        public void layout(IFigure container) {
            Rectangle bounds = UMLFragmentLabelFigure.this.getBounds();
            Point location = new Point(bounds.x + 3, bounds.y + 2);
            for (LabelFigure label : UMLFragmentLabelFigure.this.labels) {
                label.setLocation(location);
                label.setSize(label.getPreferredSize());
                Rectangle labelBounds = label.getBounds();
                location.x += labelBounds.width;
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }
}

