/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures.utils;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public class AdaptiveConnectionLocator
extends ConnectionLocator {
    public static final int OFFSET_CLOCKWISE = 0;
    public static final int OFFSET_ANTICLOCKWISE = 1;
    public static final int OFFSET_LEFT = 2;
    public static final int OFFSET_RIGHT = 3;
    public static final int OFFSET_ABOVE = 4;
    public static final int OFFSET_BELOW = 5;
    public static final int OFFSET_INSIDE = 6;
    public static final int OFFSET_OUTSIDE = 7;
    public static final int REFERENCE_RELATIVE = 0;
    public static final int REFERENCE_ABSOLUTE = 1;
    public static final int ORIENTATION_NONE = 0;
    public static final int ORIENTATION_SOURCE = 1;
    public static final int ORIENTATION_TARGET = 2;
    private int offset = 0;
    private double preciseAlignment = 0.0;
    private int reference = 0;
    private double reference_x = 0.0;
    private double reference_y = 0.0;
    private double axisBalance = 0.0;
    private int orientation = 0;

    public AdaptiveConnectionLocator(Connection connection) {
        this(connection, 4, 10, 0);
    }

    public AdaptiveConnectionLocator(Connection connection, int alignment, int gap) {
        this(connection, alignment, gap, 0);
    }

    public AdaptiveConnectionLocator(Connection connection, int alignment, int gap, int offset) {
        super(connection);
        this.setAlignment(alignment);
        this.setGap(gap);
        this.setOffset(offset);
    }

    public AdaptiveConnectionLocator(Connection connection, double preciseAlignment, int gap) {
        this(connection, preciseAlignment, gap, 0);
    }

    public AdaptiveConnectionLocator(Connection connection, double preciseAlignment, int gap, int offset) {
        super(connection);
        this.setPreciseAlignment(preciseAlignment);
        this.setGap(gap);
        this.setOffset(offset);
    }

    public double getPreciseAlignment() {
        return this.preciseAlignment;
    }

    public void setPreciseAlignment(double preciseAlignment) {
        this.preciseAlignment = preciseAlignment;
        if (preciseAlignment == 0.0) {
            super.setAlignment(2);
        } else if (preciseAlignment == 1.0) {
            super.setAlignment(3);
        } else {
            super.setAlignment(4);
        }
    }

    public void setAlignment(int align) {
        super.setAlignment(align);
        if (align == 2) {
            this.preciseAlignment = 0.0;
        } else if (align == 3) {
            this.preciseAlignment = 1.0;
        } else if (align == 4) {
            this.preciseAlignment = 0.5;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int polarity) {
        this.offset = polarity;
    }

    public double getAxisBalance() {
        return this.axisBalance;
    }

    public void setAxisBalance(double axisBalance) {
        this.axisBalance = axisBalance;
    }

    public int getReference() {
        return this.reference;
    }

    public void setReference(int reference) {
        this.reference = reference;
    }

    public double getReferenceOffsetX() {
        return this.reference_x;
    }

    public void setReferenceOffsetX(double reference_x) {
        this.reference_x = reference_x;
    }

    public double getReferenceReferenceOffsetY() {
        return this.reference_y;
    }

    public void setReferenceReferenceOffsetY(double reference_y) {
        this.reference_y = reference_y;
    }

    protected Point getAnchorLocation(PointList segments, Point p0, Point p1) {
        if (segments.size() > 1) {
            double length = 0.0;
            double[] sectionLengths = new double[segments.size()];
            sectionLengths[0] = 0.0;
            segments.getPoint(p0, 0);
            int i = 1;
            while (i < segments.size()) {
                segments.getPoint(p1, i);
                double section = p0.getDistance(p1);
                sectionLengths[i] = length += section;
                segments.getPoint(p0, i);
                ++i;
            }
            double offset = length * this.preciseAlignment;
            int index = 1;
            while (index < segments.size()) {
                if (offset <= sectionLengths[index]) break;
                ++index;
            }
            offset -= sectionLengths[index - 1];
            segments.getPoint(p0, index - 1);
            segments.getPoint(p1, index);
            length = p0.getDistance(p1);
            double r = offset / length;
            return new PrecisionPoint((double)p0.x + r * (double)(p1.x - p0.x), (double)p0.y + r * (double)(p1.y - p0.y));
        }
        return new Point();
    }

    public Point getLocation(PointList segments) {
        return this.computeRelocation(null, segments, false);
    }

    public Point getAdaptedLocation(IFigure target) {
        return this.computeRelocation(target, this.getPoints(), false);
    }

    public void relocate(IFigure target) {
        this.computeRelocation(target, this.getPoints(), true);
    }

    private Point computeRelocation(IFigure target, PointList segments, boolean relocate) {
        Point p0 = new Point();
        Point p1 = new Point();
        Point anchorLocation = this.getAnchorLocation(segments, p0, p1);
        int dx = p1.x - p0.x;
        int dy = p1.y - p0.y;
        int offsetDirection = 1;
        if (dx > 0) {
            if (this.offset == 5) {
                offsetDirection = -1;
            } else if (dy > 0 && this.offset == 6) {
                offsetDirection = -1;
            } else if (dy <= 0 && this.offset == 7) {
                offsetDirection = -1;
            }
        } else if (this.offset == 4) {
            offsetDirection = -1;
        } else if (dy > 0 && this.offset == 7) {
            offsetDirection = -1;
        } else if (dy <= 0 && this.offset == 6) {
            offsetDirection = -1;
        }
        if (dy > 0) {
            if (this.offset == 2) {
                offsetDirection = -1;
            }
        } else if (this.offset == 3) {
            offsetDirection = -1;
        }
        double ld = Math.sqrt(dx * dx + dy * dy);
        double nx = (double)(dy * offsetDirection * this.getGap()) / ld;
        double ny = (double)(-dx * offsetDirection * this.getGap()) / ld;
        double balance = ((double)this.getGap() - Math.abs(Math.abs(nx) - Math.abs(ny))) / (double)this.getGap();
        double bfx = 1.0 + this.getAxisBalance() * balance;
        bfx = bfx < 0.0 ? 0.0 : bfx;
        double bfy = 1.0 - this.getAxisBalance() * balance;
        bfy = bfy < 0.0 ? 0.0 : bfy;
        double lx = (double)anchorLocation.x + nx * bfx;
        double ly = (double)anchorLocation.y + ny * bfy;
        if (target == null) {
            return new Point((int)(0.5 + lx), (int)(0.5 + ly));
        }
        Dimension fd = target.getPreferredSize();
        double rx = (double)fd.width * this.reference_x;
        double ry = (double)fd.height * this.reference_y;
        if (this.reference == 0 && fd.width != 0 && fd.height != 0 && (nx != 0.0 || ny != 0.0)) {
            double scale = 0.5 / Math.max(Math.abs(nx) / (double)fd.width, Math.abs(ny) / (double)fd.height);
            double ix = Math.abs((double)p0.x + (ly - (double)p0.y) * (double)dx / (double)dy - lx);
            double iy = Math.abs((double)p0.y + (lx - (double)p0.x) * (double)dy / (double)dx - ly);
            double kx = (double)this.getGap() + (nx > 0.0 ? rx : (double)fd.width - (rx += 0.5 * (double)fd.width - scale * nx));
            double ky = (double)this.getGap() + (ny > 0.0 ? ry : (double)fd.height - (ry += 0.5 * (double)fd.height - scale * ny));
            if (ix < kx) {
                rx -= Math.signum(nx) * (kx - ix);
            }
            if (iy < ky) {
                ry -= Math.signum(ny) * (ky - iy);
            }
        }
        int px = (int)(0.5 + lx - rx);
        int py = (int)(0.5 + ly - ry);
        Point location = new Point(px, py);
        if (relocate) {
            target.setBounds(new Rectangle(location.x, location.y, fd.width, fd.height));
            if (this.orientation != 0 && target instanceof RotatableDecoration) {
                target.setLocation(location);
                RotatableDecoration decoration = (RotatableDecoration)target;
                if (this.orientation == 1) {
                    decoration.setReferencePoint((Point)new PrecisionPoint((double)p0.x + nx, (double)p0.y + ny));
                } else {
                    decoration.setReferencePoint((Point)new PrecisionPoint((double)p1.x + nx, (double)p1.y + ny));
                }
            }
        }
        return location;
    }

    protected PointList getPoints() {
        return this.getConnection().getPoints();
    }
}

