/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.section;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.fujaba.commons.FujabaCommonsImages;
import org.fujaba.commons.properties.section.AbstractSection;

public abstract class AbstractObjectSelectionComboSection
extends AbstractSection {
    protected CLabel label;
    protected Combo list;
    private Button advanced;
    private Map<String, Object> elements = new HashMap<String, Object>();

    @Override
    protected void createWidgets(Composite composite) {
        this.list = new Combo(composite, 12);
        this.label = this.getWidgetFactory().createCLabel(composite, this.getLabelText(), 131072);
        if (this.showAdvancedButton()) {
            this.advanced = this.getWidgetFactory().createButton(composite, this.getAdvancedButtonText(), 0x1000008);
            this.advanced.setImage(this.getAdvancedButtonImage());
        }
    }

    protected Image getAdvancedButtonImage() {
        return FujabaCommonsImages.getImage("icons/help.gif");
    }

    protected String getAdvancedButtonText() {
        return "Details";
    }

    protected abstract Object getCurrentValue();

    private String[] getItems() {
        Collection<? extends Object> possible = this.getPossibilities();
        this.elements.clear();
        String[] items = new String[possible.size()];
        int i = 0;
        for (Object object : possible) {
            String text;
            items[i] = text = this.getValueText(object);
            this.elements.put(text, object);
            ++i;
        }
        return items;
    }

    protected Object getObject(String text) {
        return this.elements.get(text);
    }

    protected abstract Collection<? extends Object> getPossibilities();

    protected abstract String getValueText(Object var1);

    protected void handleAdvancedButtonClicked() {
    }

    protected void handleSelection(SelectionEvent e) {
        if (e.getSource().equals(this.list)) {
            this.createCommand(this.getCurrentValue(), this.elements.get(this.list.getText()));
        }
    }

    @Override
    protected void hookListeners() {
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractObjectSelectionComboSection.this.handleSelection(e);
            }
        });
        if (this.advanced != null) {
            this.advanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractObjectSelectionComboSection.this.handleAdvancedButtonClicked();
                }
            });
        }
    }

    public void refresh() {
        this.list.select(this.list.indexOf(this.getValueText(this.getCurrentValue())));
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.list.setItems(this.getItems());
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        if (this.advanced != null) {
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 4);
            data.bottom = new FormAttachment(100, 0);
            this.advanced.setLayoutData((Object)data);
        }
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = this.advanced != null ? new FormAttachment((Control)this.advanced, -5) : new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.list.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.list, -5);
        data.top = new FormAttachment((Control)this.list, 0, 128);
        this.label.setLayoutData((Object)data);
    }

    protected boolean showAdvancedButton() {
        return false;
    }
}

