/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CamelCaseFilter
extends ViewerFilter {
    private static final String ANY = "\\*";
    private static final String ANY_STAR = ".*?";
    private static final String REGEX_BEGIN = "\\b(";
    private static final String REGEX_END = ".*?)\\b";
    private static final String CC_BEFORE = "([A-Z][^A-Z]*)";
    private static final String CC_AFTER = "$1[^A-Z]*";
    private String query;

    private static boolean isMatching(String query, String text) {
        return CamelCaseFilter.isMatchingPrefix(query, text) || CamelCaseFilter.isMatchingCamelCase(query, text);
    }

    private static boolean isMatchingPrefix(String query, String text) {
        return text.toLowerCase().startsWith(query.toLowerCase());
    }

    private static boolean isMatchingCamelCase(String query, String text) {
        query = query.replaceAll(ANY, ANY_STAR);
        StringBuilder regex = new StringBuilder();
        regex.append(REGEX_BEGIN);
        regex.append(query.replaceAll(CC_BEFORE, CC_AFTER));
        regex.append(REGEX_END);
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof TreeNode) {
            if (this.query != null && !this.query.trim().isEmpty()) {
                String name = ((ENamedElement)((TreeNode)element).getValue()).getName();
                if (((TreeNode)element).getChildren() != null) {
                    TreeNode[] treeNodeArray = ((TreeNode)element).getChildren();
                    int n = treeNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeNode child = treeNodeArray[n2];
                        if (this.select(viewer, parent, child)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return CamelCaseFilter.isMatching(this.query, name);
            }
            return true;
        }
        return false;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

