/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class MessageManager
implements IMessageManager {
    private static final DefaultPrefixProvider DEFAULT_PREFIX_PROVIDER = new DefaultPrefixProvider();
    private List<Message> messages = new ArrayList<Message>();
    private Hashtable<Control, ControlDecorator> decorators = new Hashtable();
    private boolean autoUpdate = true;
    private IMessagePrefixProvider prefixProvider = DEFAULT_PREFIX_PROVIDER;
    private int decorationPosition = 17408;
    private static FieldDecoration standardError = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
    private static FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");

    public void addMessage(Object key, String messageText, Object data, int type) {
        this.addMessage(null, key, messageText, data, type, this.messages);
    }

    public void addMessage(Object key, String messageText, Object data, int type, Control control) {
        ControlDecorator dec = this.decorators.get(control);
        if (dec == null) {
            dec = new ControlDecorator(control);
            this.decorators.put(control, dec);
        }
        dec.addMessage(key, messageText, data, type);
    }

    public void removeMessage(Object key) {
        Message message = this.findMessage(key, this.messages);
        if (message != null) {
            this.messages.remove(message);
        }
    }

    public void removeMessages() {
        if (!this.messages.isEmpty()) {
            this.messages.clear();
        }
    }

    public void removeMessage(Object key, Control control) {
        ControlDecorator dec = this.decorators.get(control);
        if (dec == null) {
            return;
        }
        dec.removeMessage(key);
    }

    public void removeMessages(Control control) {
        ControlDecorator dec = this.decorators.get(control);
        if (dec != null) {
            dec.removeMessages();
        }
    }

    public void removeAllMessages() {
        Enumeration<ControlDecorator> enm = this.decorators.elements();
        while (enm.hasMoreElements()) {
            ControlDecorator control = enm.nextElement();
            control.removeMessages();
        }
        if (!this.messages.isEmpty()) {
            this.messages.clear();
        }
    }

    private Message addMessage(String prefix, Object key, String messageText, Object data, int type, List<Message> list) {
        Message message = this.findMessage(key, list);
        if (message == null) {
            message = new Message(key, messageText, type, data);
            message.prefix = prefix;
            list.add(message);
        } else {
            message.message = messageText;
            message.type = type;
            message.data = data;
        }
        return message;
    }

    private Message findMessage(Object key, List<Message> list) {
        int i = 0;
        while (i < list.size()) {
            Message message = list.get(i);
            if (message.getKey().equals(key)) {
                return message;
            }
            ++i;
        }
        return null;
    }

    public void update() {
        for (ControlDecorator dec : this.decorators.values()) {
            dec.update();
        }
    }

    private static String getFullMessage(IMessage message) {
        if (message.getPrefix() == null) {
            return message.getMessage();
        }
        return String.valueOf(message.getPrefix()) + message.getMessage();
    }

    private List<Message> createPeers(List<Message> msges) {
        ArrayList<Message> peers = new ArrayList<Message>();
        int maxType = 0;
        int i = 0;
        while (i < msges.size()) {
            Message message = msges.get(i);
            if (message.type > maxType) {
                peers.clear();
                maxType = message.type;
            }
            if (message.type == maxType) {
                peers.add(message);
            }
            ++i;
        }
        return peers;
    }

    private String createDetails(List<Message> msges, boolean excludePrefix) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        int i = 0;
        while (i < msges.size()) {
            if (i > 0) {
                out.println();
            }
            IMessage m = msges.get(i);
            out.print(excludePrefix ? m.getMessage() : MessageManager.getFullMessage(m));
            ++i;
        }
        out.flush();
        return sw.toString();
    }

    public static String createDetails(IMessage[] messages) {
        if (messages == null || messages.length == 0) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        int i = 0;
        while (i < messages.length) {
            if (i > 0) {
                out.println();
            }
            out.print(MessageManager.getFullMessage(messages[i]));
            ++i;
        }
        out.flush();
        return sw.toString();
    }

    public String createSummary(IMessage[] msges) {
        return MessageManager.createDetails(msges);
    }

    public IMessagePrefixProvider getMessagePrefixProvider() {
        return this.prefixProvider;
    }

    public void setMessagePrefixProvider(IMessagePrefixProvider provider) {
        this.prefixProvider = provider;
        for (ControlDecorator dec : this.decorators.values()) {
            dec.updatePrefix();
        }
    }

    public int getDecorationPosition() {
        return this.decorationPosition;
    }

    public void setDecorationPosition(int position) {
        this.decorationPosition = position;
        for (ControlDecorator dec : this.decorators.values()) {
            dec.updatePosition();
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        boolean needsUpdate = !this.autoUpdate && autoUpdate;
        this.autoUpdate = autoUpdate;
        if (needsUpdate) {
            this.update();
        }
    }

    class ControlDecorator {
        private ControlDecoration decoration;
        private List<Message> controlMessages = new ArrayList<Message>();
        private String prefix;

        ControlDecorator(Control control) {
            this.decoration = new ControlDecoration(control, MessageManager.this.decorationPosition);
        }

        public boolean isDisposed() {
            return this.decoration.getControl() == null;
        }

        void updatePrefix() {
            this.prefix = null;
        }

        void updatePosition() {
            Control control = this.decoration.getControl();
            this.decoration.dispose();
            this.decoration = new ControlDecoration(control, MessageManager.this.decorationPosition);
            this.update();
        }

        String getPrefix() {
            if (this.prefix == null) {
                this.createPrefix();
            }
            return this.prefix;
        }

        private void createPrefix() {
            if (MessageManager.this.prefixProvider == null) {
                this.prefix = "";
                return;
            }
            this.prefix = MessageManager.this.prefixProvider.getPrefix(this.decoration.getControl());
            if (this.prefix == null) {
                this.prefix = "";
            }
        }

        void addAll(List<Message> target) {
            target.addAll(this.controlMessages);
        }

        void addMessage(Object key, String text, Object data, int type) {
            Message message = MessageManager.this.addMessage(this.getPrefix(), key, text, data, type, this.controlMessages);
            message.control = this.decoration.getControl();
            if (MessageManager.this.isAutoUpdate()) {
                this.update();
            }
        }

        boolean removeMessage(Object key) {
            Message message = MessageManager.this.findMessage(key, this.controlMessages);
            if (message != null) {
                this.controlMessages.remove(message);
                if (MessageManager.this.isAutoUpdate()) {
                    this.update();
                }
            }
            return message != null;
        }

        boolean removeMessages() {
            if (this.controlMessages.isEmpty()) {
                return false;
            }
            this.controlMessages.clear();
            if (MessageManager.this.isAutoUpdate()) {
                this.update();
            }
            return true;
        }

        public void update() {
            if (this.controlMessages.isEmpty()) {
                this.decoration.setDescriptionText(null);
                this.decoration.hide();
            } else {
                List peers = MessageManager.this.createPeers(this.controlMessages);
                int type = ((IMessage)peers.get(0)).getMessageType();
                String description = MessageManager.this.createDetails(MessageManager.this.createPeers(peers), true);
                if (type == 3) {
                    this.decoration.setImage(standardError.getImage());
                } else if (type == 2) {
                    this.decoration.setImage(standardWarning.getImage());
                }
                this.decoration.setDescriptionText(description);
                this.decoration.show();
            }
        }
    }

    static class DefaultPrefixProvider
    implements IMessagePrefixProvider {
        DefaultPrefixProvider() {
        }

        public String getPrefix(Control c) {
            Composite parent = c.getParent();
            Control[] siblings = parent.getChildren();
            int i = 0;
            while (i < siblings.length) {
                if (siblings[i] == c) {
                    int j = i - 1;
                    while (j >= 0) {
                        Control label = siblings[j];
                        String ltext = null;
                        if (label instanceof Label) {
                            ltext = ((Label)label).getText();
                        } else if (label instanceof Hyperlink) {
                            ltext = ((Hyperlink)label).getText();
                        } else if (label instanceof CLabel) {
                            ltext = ((CLabel)label).getText();
                        }
                        if (ltext != null) {
                            if (!ltext.endsWith(":")) {
                                return String.valueOf(ltext) + ": ";
                            }
                            return String.valueOf(ltext) + " ";
                        }
                        --j;
                    }
                    break;
                }
                ++i;
            }
            return null;
        }
    }

    static class Message
    implements IMessage {
        Control control;
        Object data;
        Object key;
        String message;
        int type;
        String prefix;

        Message(Object key, String message, int type, Object data) {
            this.key = key;
            this.message = message;
            this.type = type;
            this.data = data;
        }

        public Object getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }

        public Control getControl() {
            return this.control;
        }

        public Object getData() {
            return this.data;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

