/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileExtensionViewerFilter
extends ViewerFilter {
    private final String[] extensions;

    public FileExtensionViewerFilter(String[] extensions) {
        this.extensions = extensions;
    }

    public FileExtensionViewerFilter(String extension) {
        this(new String[]{extension});
    }

    public FileExtensionViewerFilter() {
        this("*");
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IContainer) {
            return this.hasValidFileInside((IContainer)element);
        }
        if (element instanceof IFile) {
            return this.isValid(((IFile)element).getFileExtension());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasValidFileInside(IContainer element) {
        if (!element.isAccessible()) return false;
        if (element.isHidden()) return false;
        try {
            IResource[] iResourceArray = element.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource child = iResourceArray[n2];
                if (child instanceof IContainer && this.hasValidFileInside((IContainer)child)) {
                    return true;
                }
                if (child instanceof IFile && this.isValid(((IFile)child).getFileExtension())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return false;
        }
    }

    private boolean isValid(String extension) {
        String[] stringArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String valid = stringArray[n2];
            if (valid.equals("*")) {
                return true;
            }
            if (extension != null && extension.equalsIgnoreCase(valid)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

