/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FileInputValidator
implements ISelectionStatusValidator {
    private static final String INVALID = "The selection is not valid.";
    private static final String VALID = "The selection seems to be valid.";
    private final String[] extensions;
    private final int max;

    public FileInputValidator(String[] extensions, int max) {
        this.extensions = extensions;
        this.max = max;
    }

    public FileInputValidator(String extension, int max) {
        this(new String[]{extension}, max);
    }

    public FileInputValidator(int max) {
        this("*", max);
    }

    public FileInputValidator(String[] extensions) {
        this(extensions, 1);
    }

    public FileInputValidator(String extension) {
        this(new String[]{extension});
    }

    public FileInputValidator() {
        this("*");
    }

    public IStatus validate(Object[] selection) {
        Status valid = new Status(0, "org.fujaba.commons", VALID);
        Status invalid = new Status(4, "org.fujaba.commons", INVALID);
        if (selection.length > 0 && selection.length <= this.max) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected instanceof IFile) {
                    if (!this.isValid(((IFile)selected).getFileExtension())) {
                        return invalid;
                    }
                } else {
                    return invalid;
                }
                ++n2;
            }
            return valid;
        }
        return invalid;
    }

    private boolean isValid(String extension) {
        String[] stringArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String valid = stringArray[n2];
            if (valid.equals("*")) {
                return true;
            }
            if (extension != null && extension.equalsIgnoreCase(valid)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

