/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrderedNode<T> {
    private T element = null;
    private boolean root = false;
    private String id = "n/a";
    private Map<OrderedNode<T>, Boolean> next;
    private Map<OrderedNode<T>, Boolean> previous;

    public OrderedNode(String id, T element) {
        this.element = element;
        this.id = id;
        this.previous = new ConcurrentHashMap<OrderedNode<T>, Boolean>();
        this.next = new ConcurrentHashMap<OrderedNode<T>, Boolean>();
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setElement(T element) {
        this.element = element;
    }

    public T getElement() {
        return this.element;
    }

    public String getId() {
        return this.id;
    }

    public boolean addToNext(OrderedNode<T> value) {
        boolean changed = false;
        if (value != null) {
            changed = !this.next.containsKey(value);
            this.next.put(value, Boolean.TRUE);
            if (changed) {
                value.addToPrevious(this);
            }
        }
        return changed;
    }

    public boolean removeFromNext(OrderedNode<T> value) {
        boolean changed = false;
        if (value != null) {
            changed = this.next.containsKey(value);
            this.next.remove(value);
            if (changed) {
                value.removeFromPrevious(this);
            }
        }
        return changed;
    }

    public void removeAllFromNext() {
        Iterator<OrderedNode<T>> iter = this.iteratorOfNext();
        while (iter.hasNext()) {
            OrderedNode<T> tmpValue = iter.next();
            this.removeFromNext(tmpValue);
        }
    }

    public boolean hasInNext(OrderedNode<T> value) {
        return value != null && this.next.containsKey(value);
    }

    public Iterator<OrderedNode<T>> iteratorOfNext() {
        return this.next.keySet().iterator();
    }

    public int sizeOfNext() {
        return this.next.size();
    }

    public boolean addToPrevious(OrderedNode<T> value) {
        boolean changed = false;
        if (value != null) {
            changed = !this.previous.containsKey(value);
            this.previous.put(value, Boolean.TRUE);
            if (changed) {
                value.addToNext(this);
            }
        }
        return changed;
    }

    public boolean removeFromPrevious(OrderedNode<T> value) {
        boolean changed = false;
        if (value != null) {
            changed = this.previous.containsKey(value);
            this.previous.remove(value);
            if (changed) {
                value.removeFromNext(this);
            }
        }
        return changed;
    }

    public void removeAllFromPrevious() {
        Iterator<OrderedNode<T>> iter = this.iteratorOfPrevious();
        while (iter.hasNext()) {
            OrderedNode<T> tmpValue = iter.next();
            this.removeFromPrevious(tmpValue);
        }
    }

    public boolean hasInPrevious(OrderedNode<T> value) {
        return value != null && this.previous.containsKey(value);
    }

    public Iterator<OrderedNode<T>> iteratorOfPrevious() {
        return this.previous.keySet().iterator();
    }

    public int sizeOfPrevious() {
        return this.previous.size();
    }

    public void removeYou() {
        this.removeAllFromNext();
        this.removeAllFromPrevious();
    }
}

