/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.generate.GraphGenerator;

public class CompleteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private final int size;

    public CompleteGraphGenerator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        this.size = size;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        int i;
        if (this.size < 1) {
            return;
        }
        GraphTests.requireDirectedOrUndirected(target);
        boolean isDirected = target.getType().isDirected();
        ArrayList<V> nodes = new ArrayList<V>(this.size);
        for (i = 0; i < this.size; ++i) {
            nodes.add(target.addVertex());
        }
        for (i = 0; i < this.size; ++i) {
            for (int j = i + 1; j < this.size; ++j) {
                Object v = nodes.get(i);
                Object u = nodes.get(j);
                target.addEdge(v, u);
                if (!isDirected) continue;
                target.addEdge(u, v);
            }
        }
    }
}

