/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.AbstractList;
import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.shortestpath.AbstractPathElement;

abstract class AbstractPathElementList<V, E, T extends AbstractPathElement<V, E>>
extends AbstractList<T> {
    protected Graph<V, E> graph;
    protected int maxSize;
    protected ArrayList<T> pathElements = new ArrayList();
    protected V vertex;

    protected AbstractPathElementList(Graph<V, E> graph, AbstractPathElementList<V, E, T> elementList, E edge) {
        if (elementList == null) {
            throw new NullPointerException("elementList is null");
        }
        if (edge == null) {
            throw new NullPointerException("edge is null");
        }
        this.graph = graph;
        this.maxSize = Integer.MAX_VALUE;
        this.vertex = Graphs.getOppositeVertex(graph, edge, elementList.getVertex());
    }

    protected AbstractPathElementList(Graph<V, E> graph, T pathElement) {
        if (pathElement == null) {
            throw new NullPointerException("pathElement is null");
        }
        if (((AbstractPathElement)pathElement).getPrevEdge() != null) {
            throw new IllegalArgumentException("path must be empty");
        }
        this.graph = graph;
        this.maxSize = Integer.MAX_VALUE;
        this.vertex = ((AbstractPathElement)pathElement).getVertex();
        this.pathElements.add(pathElement);
    }

    protected AbstractPathElementList(Graph<V, E> graph, V vertex) {
        this.graph = graph;
        this.maxSize = Integer.MAX_VALUE;
        this.vertex = vertex;
    }

    @Override
    public T get(int index) {
        return (T)((AbstractPathElement)this.pathElements.get(index));
    }

    public V getVertex() {
        return this.vertex;
    }

    @Override
    public int size() {
        return this.pathElements.size();
    }
}

