/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CompoundCRS;

public final class CompoundCoordinates<C1 extends Coordinates<?>, C2 extends Coordinates<?>>
extends Coordinates<CompoundCRS<C1, C2>> {
    private C1 _first;
    private C2 _next;
    private static final ObjectFactory<CompoundCoordinates> FACTORY = new ObjectFactory<CompoundCoordinates>(){

        protected CompoundCoordinates create() {
            return new CompoundCoordinates();
        }
    };
    static final XMLFormat<CompoundCoordinates> XML = new XMLFormat<CompoundCoordinates>(CompoundCoordinates.class){

        public CompoundCoordinates newInstance(Class<CompoundCoordinates> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (CompoundCoordinates)FACTORY.object();
        }

        public void read(XMLFormat.InputElement xml, CompoundCoordinates coord) throws XMLStreamException {
            coord._first = (Coordinates)xml.getNext();
            coord._next = (Coordinates)xml.getNext();
        }

        public void write(CompoundCoordinates coord, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.add(coord._first);
            xml.add(coord._next);
        }
    };
    private static final long serialVersionUID = 1L;

    public static <T1 extends Coordinates<?>, T2 extends Coordinates<?>> CompoundCoordinates<T1, T2> valueOf(T1 first, T2 next) {
        CompoundCoordinates coord = (CompoundCoordinates)FACTORY.object();
        coord._first = first;
        coord._next = next;
        return coord;
    }

    private CompoundCoordinates() {
    }

    public C1 getFirst() {
        return this._first;
    }

    public C2 getNext() {
        return this._next;
    }

    @Override
    public CompoundCRS<C1, C2> getCoordinateReferenceSystem() {
        return new CompoundCRS(((Coordinates)this._first).getCoordinateReferenceSystem(), ((Coordinates)this._next).getCoordinateReferenceSystem());
    }

    @Override
    public int getDimension() {
        return ((Coordinates)this._first).getDimension() + ((Coordinates)this._next).getDimension();
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        int firstDimension = ((Coordinates)this._first).getDimension();
        if (dimension < firstDimension) {
            return ((Coordinates)this._first).getOrdinate(dimension);
        }
        return ((Coordinates)this._next).getOrdinate(dimension - firstDimension);
    }

    @Override
    public CompoundCoordinates<?, ?> copy() {
        return CompoundCoordinates.valueOf(this._first, this._next);
    }
}

