/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javax.measure.Measure;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.jscience.geography.coordinates.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public final class LatLong
extends Coordinates<GeographicCRS<?>> {
    public static final GeographicCRS<LatLong> CRS = new GeographicCRS<LatLong>(){

        @Override
        protected LatLong coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
            return LatLong.valueOf(position.latitudeWGS84.doubleValue(NonSI.DEGREE_ANGLE), position.longitudeWGS84.doubleValue(NonSI.DEGREE_ANGLE), NonSI.DEGREE_ANGLE);
        }

        @Override
        protected CoordinateReferenceSystem.AbsolutePosition positionOf(LatLong coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
            position.latitudeWGS84 = Measure.valueOf(coordinates._latitude, NonSI.DEGREE_ANGLE);
            position.longitudeWGS84 = Measure.valueOf(coordinates._longitude, NonSI.DEGREE_ANGLE);
            return position;
        }

        @Override
        public CoordinateSystem getCoordinateSystem() {
            return GeographicCRS.LATITUDE_LONGITUDE_CS;
        }
    };
    private static final UnitConverter DEGREE_TO_RADIAN = NonSI.DEGREE_ANGLE.getConverterTo(SI.RADIAN);
    private static final UnitConverter RADIAN_TO_DEGREE = DEGREE_TO_RADIAN.inverse();
    private double _latitude;
    private double _longitude;
    private static final ObjectFactory<LatLong> FACTORY = new ObjectFactory<LatLong>(){

        protected LatLong create() {
            return new LatLong();
        }
    };
    static final XMLFormat<LatLong> XML = new XMLFormat<LatLong>(LatLong.class){

        public LatLong newInstance(Class<LatLong> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (LatLong)FACTORY.object();
        }

        public void write(LatLong latLong, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("latitude", latLong._latitude);
            xml.setAttribute("longitude", latLong._longitude);
        }

        public void read(XMLFormat.InputElement xml, LatLong latLong) throws XMLStreamException {
            latLong._latitude = xml.getAttribute("latitude", 0.0);
            latLong._longitude = xml.getAttribute("longitude", 0.0);
        }
    };
    private static final long serialVersionUID = 1L;

    public static LatLong valueOf(double latitude, double longitude, Unit<Angle> unit) {
        LatLong latLong = (LatLong)FACTORY.object();
        if (unit == NonSI.DEGREE_ANGLE) {
            latLong._latitude = latitude;
            latLong._longitude = longitude;
        } else if (unit == SI.RADIAN) {
            latLong._latitude = RADIAN_TO_DEGREE.convert(latitude);
            latLong._longitude = RADIAN_TO_DEGREE.convert(longitude);
        } else {
            UnitConverter toDegree = unit.getConverterTo(NonSI.DEGREE_ANGLE);
            latLong._latitude = toDegree.convert(latitude);
            latLong._longitude = toDegree.convert(longitude);
        }
        return latLong;
    }

    private LatLong() {
    }

    public final double latitudeValue(Unit<Angle> unit) {
        return unit == NonSI.DEGREE_ANGLE ? this._latitude : (unit == SI.RADIAN ? DEGREE_TO_RADIAN.convert(this._latitude) : NonSI.DEGREE_ANGLE.getConverterTo(unit).convert(this._latitude));
    }

    public final double longitudeValue(Unit<Angle> unit) {
        return unit == NonSI.DEGREE_ANGLE ? this._longitude : (unit == SI.RADIAN ? DEGREE_TO_RADIAN.convert(this._longitude) : NonSI.DEGREE_ANGLE.getConverterTo(unit).convert(this._longitude));
    }

    @Override
    public GeographicCRS<LatLong> getCoordinateReferenceSystem() {
        return CRS;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            Unit<?> u = GeographicCRS.LATITUDE_LONGITUDE_CS.getAxis(0).getUnit();
            return NonSI.DEGREE_ANGLE.getConverterTo(u).convert(this._latitude);
        }
        if (dimension == 1) {
            Unit<?> u = GeographicCRS.LATITUDE_LONGITUDE_CS.getAxis(1).getUnit();
            return NonSI.DEGREE_ANGLE.getConverterTo(u).convert(this._longitude);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public LatLong copy() {
        return LatLong.valueOf(this._latitude, this._longitude, NonSI.DEGREE_ANGLE);
    }
}

