/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.io.Serializable;
import javolution.context.ArrayFactory;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.Text;
import javolution.text.TextBuilder;
import org.jscience.mathematics.function.FunctionException;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.structure.Ring;

public final class Term
implements Serializable,
Comparable<Term>,
ValueType,
Realtime {
    public static Term ONE = new Term(0);
    private static final ArrayFactory<Term> FACTORY = new ArrayFactory<Term>(){

        protected Term create(int size) {
            return new Term(size);
        }
    };
    private final Variable<?>[] _variables;
    private final int[] _powers;
    private int _size;
    private static final long serialVersionUID = 1L;

    private Term(int capacity) {
        this._variables = new Variable[capacity];
        this._powers = new int[capacity];
    }

    public static Term valueOf(Variable<?> v, int n) {
        if (n == 0) {
            return ONE;
        }
        if (n < 0) {
            throw new IllegalArgumentException("n: " + n + " negative values are not allowed");
        }
        Term term = (Term)FACTORY.array(1);
        term._variables[0] = v;
        term._powers[0] = n;
        term._size = 1;
        return term;
    }

    public int size() {
        return this._size;
    }

    public Variable<?> getVariable(int index) {
        if (index > this._size) {
            throw new IllegalArgumentException();
        }
        return this._variables[index];
    }

    public int getPower(int index) {
        if (index > this._size) {
            throw new IllegalArgumentException();
        }
        return this._powers[index];
    }

    public int getPower(Variable<?> v) {
        int i = 0;
        while (i < this._size) {
            if (this._variables[i] == v) {
                return this._powers[i];
            }
            ++i;
        }
        return 0;
    }

    public Term times(Term that) {
        Variable<?> left;
        int thisSize = this.size();
        int thatSize = that.size();
        Term result = (Term)FACTORY.array(thisSize + thatSize);
        result._size = 0;
        int i = 0;
        int j = 0;
        while (true) {
            Variable<?> right;
            left = i < thisSize ? this._variables[i] : null;
            Variable<?> variable = right = j < thatSize ? that._variables[j] : null;
            if (left == null) {
                if (right == null) {
                    return result;
                }
                result._powers[result._size] = that._powers[j++];
                result._variables[result._size++] = right;
                continue;
            }
            if (right == null) {
                result._powers[result._size] = this._powers[i++];
                result._variables[result._size++] = left;
                continue;
            }
            if (right == left) {
                result._powers[result._size] = this._powers[i++] + that._powers[j++];
                result._variables[result._size++] = right;
                continue;
            }
            int cmp = left.getSymbol().compareTo(right.getSymbol());
            if (cmp < 0) {
                result._powers[result._size] = this._powers[i++];
                result._variables[result._size++] = left;
                continue;
            }
            if (cmp <= 0) break;
            result._powers[result._size] = that._powers[j++];
            result._variables[result._size++] = right;
        }
        throw new IllegalArgumentException("Found distinct variables with same symbol: " + left.getSymbol());
    }

    public Term divide(Term that) {
        int cmp;
        Variable<?> left;
        int thisSize = this._size;
        int thatSize = that._size;
        Term result = (Term)FACTORY.array(MathLib.max((int)thisSize, (int)thatSize));
        result._size = 0;
        int i = 0;
        int j = 0;
        while (true) {
            Variable<?> right;
            left = i < thisSize ? this._variables[i] : null;
            Variable<?> variable = right = j < thatSize ? that._variables[j] : null;
            if (left == null) {
                if (right == null) {
                    return result;
                }
                throw new UnsupportedOperationException(this + "/" + that + " would result in a negative power");
            }
            if (right == null) {
                result._powers[result._size] = this._powers[i++];
                result._variables[result._size++] = left;
                continue;
            }
            if (right == left) {
                int power;
                if ((power = this._powers[i++] - that._powers[j++]) < 0) {
                    throw new UnsupportedOperationException(this + "/" + that + " would result in a negative power");
                }
                if (power <= 0) continue;
                result._powers[result._size] = power;
                result._variables[result._size++] = right;
                continue;
            }
            cmp = left.getSymbol().compareTo(right.getSymbol());
            if (cmp >= 0) break;
            result._powers[result._size] = this._powers[i++];
            result._variables[result._size++] = left;
        }
        if (cmp > 0) {
            throw new UnsupportedOperationException(this + "/" + that + " would result in a negative power");
        }
        throw new IllegalArgumentException("Found distinct variables with same symbol: " + left.getSymbol());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Term)) {
            return false;
        }
        Term that = (Term)obj;
        if (this._size != that._size) {
            return false;
        }
        int i = 0;
        while (i < this._size) {
            if (!this._variables[i].equals(that._variables[i]) || this._powers[i] != that._powers[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this._size) {
            h += this._variables[i].hashCode() * this._powers[i];
            ++i;
        }
        return h;
    }

    public final String toString() {
        return this.toText().toString();
    }

    public Text toText() {
        TextBuilder tb = TextBuilder.newInstance();
        int i = 0;
        while (i < this._size) {
            tb.append(this._variables[i].getSymbol());
            int power = this._powers[i];
            switch (power) {
                case 1: {
                    break;
                }
                case 2: {
                    tb.append('\u00b2');
                    break;
                }
                case 3: {
                    tb.append('\u00b3');
                    break;
                }
                default: {
                    tb.append(power);
                }
            }
            ++i;
        }
        return tb.toText();
    }

    public Term copy() {
        Term term = (Term)FACTORY.array(this._size);
        term._size = this._size;
        int i = 0;
        while (i < this._size) {
            term._powers[i] = this._powers[i];
            term._variables[i] = this._variables[i];
            ++i;
        }
        return term;
    }

    @Override
    public int compareTo(Term that) {
        int n = Math.min(this._size, that._size);
        int i = 0;
        while (i < n) {
            int cmp = this._variables[i].getSymbol().compareTo(that._variables[i].getSymbol());
            if (cmp != 0) {
                return cmp;
            }
            cmp = that._powers[i] - this._powers[i];
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return that._size - this._size;
    }

    Ring evaluate() {
        Ring result = null;
        int i = 0;
        while (i < this._size) {
            Ring pow2 = (Ring)this._variables[i].get();
            if (pow2 == null) {
                throw new FunctionException("Variable: " + this._variables[i] + " is not set");
            }
            int n = this._powers[i];
            while (n >= 1) {
                if ((n & 1) == 1) {
                    result = result == null ? pow2 : result.times(pow2);
                }
                pow2 = pow2.times(pow2);
                n >>>= 1;
            }
            ++i;
        }
        return result;
    }
}

