/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TypeFormat;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;

public final class Float64
extends Number<Float64>
implements Field<Float64> {
    static final XMLFormat<Float64> XML = new XMLFormat<Float64>(Float64.class){

        public Float64 newInstance(Class<Float64> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Float64.valueOf(xml.getAttribute("value", 0.0));
        }

        public void write(Float64 float64, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", float64._value);
        }

        public void read(XMLFormat.InputElement xml, Float64 float64) {
        }
    };
    private static final ObjectFactory<Float64> FACTORY = new ObjectFactory<Float64>(){

        protected Float64 create() {
            return new Float64();
        }
    };
    public static final Float64 ZERO = new Float64(0.0);
    public static final Float64 ONE = new Float64(1.0);
    private double _value;
    private static final long serialVersionUID = 1L;

    private Float64() {
    }

    private Float64(double doubleValue) {
        this._value = doubleValue;
    }

    public static Float64 valueOf(double doubleValue) {
        Float64 r = (Float64)FACTORY.object();
        r._value = doubleValue;
        return r;
    }

    public static Float64 valueOf(CharSequence chars) {
        Float64 r = (Float64)FACTORY.object();
        r._value = TypeFormat.parseDouble((CharSequence)chars);
        return r;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this._value);
    }

    public boolean isNaN() {
        return Double.isNaN(this._value);
    }

    public long round() {
        return MathLib.round((double)this._value);
    }

    @Override
    public Float64 opposite() {
        Float64 r = (Float64)FACTORY.object();
        r._value = -this._value;
        return r;
    }

    @Override
    public Float64 plus(Float64 that) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value + that._value;
        return r;
    }

    @Override
    public Float64 plus(double value) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value + value;
        return r;
    }

    @Override
    public Float64 minus(Float64 that) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value - that._value;
        return r;
    }

    @Override
    public Float64 minus(double value) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value - value;
        return r;
    }

    @Override
    public Float64 times(Float64 that) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value * that._value;
        return r;
    }

    @Override
    public Float64 times(double value) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value * value;
        return r;
    }

    @Override
    public Float64 inverse() {
        Float64 r = (Float64)FACTORY.object();
        r._value = 1.0 / this._value;
        return r;
    }

    public Float64 divide(Float64 that) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value / that._value;
        return r;
    }

    public Float64 divide(double value) {
        Float64 r = (Float64)FACTORY.object();
        r._value = this._value / value;
        return r;
    }

    @Override
    public boolean isLargerThan(Float64 that) {
        return MathLib.abs((double)this._value) > MathLib.abs((double)that._value);
    }

    public Float64 abs() {
        Float64 r = (Float64)FACTORY.object();
        r._value = MathLib.abs((double)this._value);
        return r;
    }

    public Float64 sqrt() {
        Float64 r = (Float64)FACTORY.object();
        r._value = MathLib.sqrt((double)this._value);
        return r;
    }

    public Float64 exp() {
        Float64 r = (Float64)FACTORY.object();
        r._value = MathLib.exp((double)this._value);
        return r;
    }

    public Float64 log() {
        Float64 r = (Float64)FACTORY.object();
        r._value = MathLib.log((double)this._value);
        return r;
    }

    public Float64 pow(Float64 that) {
        Float64 r = (Float64)FACTORY.object();
        r._value = MathLib.pow((double)this._value, (double)that._value);
        return r;
    }

    public Float64 pow(double e) {
        Float64 r = (Float64)FACTORY.object();
        r._value = MathLib.pow((double)this._value, (double)e);
        return r;
    }

    @Override
    public Text toText() {
        return Text.valueOf((double)this._value);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Float64 && this._value == ((Float64)that)._value;
    }

    public boolean equals(double value) {
        return this._value == value;
    }

    @Override
    public int compareTo(double value) {
        long l2;
        if (this._value < value) {
            return -1;
        }
        if (this._value > value) {
            return 1;
        }
        long l1 = Double.doubleToLongBits(this._value);
        return l1 == (l2 = Double.doubleToLongBits(value)) ? 0 : (l1 < l2 ? -1 : 1);
    }

    @Override
    public int hashCode() {
        int h = Float.floatToIntBits((float)this._value);
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    @Override
    public long longValue() {
        return (long)this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public int compareTo(Float64 that) {
        return this.compareTo(that._value);
    }

    @Override
    public Float64 copy() {
        return Float64.valueOf(this._value);
    }
}

