/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.ObjectFactory;
import javolution.text.Text;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.LargeInteger;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;

public final class Rational
extends Number<Rational>
implements Field<Rational> {
    static final XMLFormat<Rational> XML = new XMLFormat<Rational>(Rational.class){

        public Rational newInstance(Class<Rational> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Rational.valueOf((CharSequence)xml.getAttribute("value"));
        }

        public void write(Rational rational, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (CharSequence)rational.toText());
        }

        public void read(XMLFormat.InputElement xml, Rational rational) {
        }
    };
    private static final ObjectFactory<Rational> FACTORY = new ObjectFactory<Rational>(){

        protected Rational create() {
            return new Rational();
        }
    };
    public static final Rational ZERO = new Rational(LargeInteger.ZERO, LargeInteger.ONE);
    public static final Rational ONE = new Rational(LargeInteger.ONE, LargeInteger.ONE);
    private LargeInteger _dividend;
    private LargeInteger _divisor;
    private static final long serialVersionUID = 1L;

    private Rational() {
    }

    private Rational(LargeInteger dividend, LargeInteger divisor) {
        this._dividend = dividend;
        this._divisor = divisor;
    }

    public static Rational valueOf(long dividend, long divisor) {
        Rational r = (Rational)FACTORY.object();
        r._dividend = LargeInteger.valueOf(dividend);
        r._divisor = LargeInteger.valueOf(divisor);
        return r.normalize();
    }

    public static Rational valueOf(LargeInteger dividend, LargeInteger divisor) {
        Rational r = (Rational)FACTORY.object();
        r._dividend = dividend;
        r._divisor = divisor;
        return r.normalize();
    }

    public static Rational valueOf(CharSequence chars) {
        Text txt = Text.valueOf((Object)chars);
        int sep = txt.indexOf((CharSequence)"/");
        if (sep >= 0) {
            LargeInteger dividend = LargeInteger.valueOf((CharSequence)txt.subtext(0, sep));
            LargeInteger divisor = LargeInteger.valueOf((CharSequence)txt.subtext(sep + 1, chars.length()));
            return Rational.valueOf(dividend, divisor);
        }
        return Rational.valueOf(LargeInteger.valueOf((CharSequence)txt), LargeInteger.ONE);
    }

    public LargeInteger getDividend() {
        return this._dividend;
    }

    public LargeInteger getDivisor() {
        return this._divisor;
    }

    public LargeInteger round() {
        LargeInteger halfDivisor = this._divisor.times2pow(-1);
        return this.isNegative() ? this._dividend.minus(halfDivisor).divide(this._divisor) : this._dividend.plus(halfDivisor).divide(this._divisor);
    }

    @Override
    public Rational opposite() {
        return Rational.valueOf(this._dividend.opposite(), this._divisor);
    }

    @Override
    public Rational plus(Rational that) {
        return Rational.valueOf(this._dividend.times(that._divisor).plus(this._divisor.times(that._dividend)), this._divisor.times(that._divisor)).normalize();
    }

    @Override
    public Rational minus(Rational that) {
        return Rational.valueOf(this._dividend.times(that._divisor).minus(this._divisor.times(that._dividend)), this._divisor.times(that._divisor)).normalize();
    }

    @Override
    public Rational times(long multiplier) {
        return this.times(Rational.valueOf(multiplier, 1L));
    }

    @Override
    public Rational times(Rational that) {
        Rational r = Rational.valueOf(this._dividend.times(that._dividend), this._divisor.times(that._divisor)).normalize();
        return r;
    }

    @Override
    public Rational inverse() {
        if (this._dividend.isZero()) {
            throw new ArithmeticException("Dividend is zero");
        }
        return this._dividend.isNegative() ? Rational.valueOf(this._divisor.opposite(), this._dividend.opposite()) : Rational.valueOf(this._divisor, this._dividend);
    }

    public Rational divide(Rational that) {
        return Rational.valueOf(this._dividend.times(that._divisor), this._divisor.times(that._dividend)).normalize();
    }

    public Rational abs() {
        return Rational.valueOf(this._dividend.abs(), this._divisor);
    }

    public boolean isZero() {
        return this._dividend.isZero();
    }

    public boolean isPositive() {
        return this._dividend.isPositive();
    }

    public boolean isNegative() {
        return this._dividend.isNegative();
    }

    @Override
    public boolean isLargerThan(Rational that) {
        return this._dividend.times(that._divisor).isLargerThan(that._dividend.times(this._divisor));
    }

    @Override
    public Text toText() {
        return this._dividend.toText().concat(Text.valueOf((char)'/')).concat(this._divisor.toText());
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Rational) {
            return this._dividend.equals(((Rational)that)._dividend) && this._divisor.equals(((Rational)that)._divisor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3191 * this._dividend.hashCode() + 9811 * this._divisor.hashCode();
    }

    @Override
    public long longValue() {
        return this._dividend.divide(this._divisor).longValue();
    }

    @Override
    public double doubleValue() {
        int divisorBitLength;
        if (this._dividend.isNegative()) {
            return -this.abs().doubleValue();
        }
        int dividendBitLength = this._dividend.bitLength();
        if (dividendBitLength > (divisorBitLength = this._divisor.bitLength())) {
            int shift = divisorBitLength - 63;
            long divisor = this._divisor.shiftRight(shift).longValue();
            LargeInteger dividend = this._dividend.shiftRight(shift);
            return dividend.doubleValue() / (double)divisor;
        }
        int shift = dividendBitLength - 63;
        long dividend = this._dividend.shiftRight(shift).longValue();
        LargeInteger divisor = this._divisor.shiftRight(shift);
        return (double)dividend / divisor.doubleValue();
    }

    @Override
    public int compareTo(Rational that) {
        return this._dividend.times(that._divisor).compareTo(that._dividend.times(this._divisor));
    }

    private Rational normalize() {
        if (!this._divisor.isZero()) {
            if (this._divisor.isPositive()) {
                LargeInteger gcd = this._dividend.gcd(this._divisor);
                if (!gcd.equals(LargeInteger.ONE)) {
                    this._dividend = this._dividend.divide(gcd);
                    this._divisor = this._divisor.divide(gcd);
                }
                return this;
            }
            this._dividend = this._dividend.opposite();
            this._divisor = this._divisor.opposite();
            return this.normalize();
        }
        throw new ArithmeticException("Zero divisor");
    }

    @Override
    public Rational copy() {
        Rational r = (Rational)FACTORY.object();
        r._dividend = this._dividend.copy();
        r._divisor = this._divisor.copy();
        return r;
    }
}

