/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.List;
import javolution.context.ObjectFactory;
import javolution.context.StackContext;
import javolution.lang.ValueType;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Vector;

public final class DenseVector<F extends Field<F>>
extends Vector<F> {
    protected static final XMLFormat<DenseVector> XML = new XMLFormat<DenseVector>(DenseVector.class){

        public DenseVector newInstance(Class<DenseVector> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (DenseVector)FACTORY.object();
        }

        public void read(XMLFormat.InputElement xml, DenseVector V) throws XMLStreamException {
            int dimension = xml.getAttribute("dimension", 0);
            int i = 0;
            while (i < dimension) {
                V._elements.add(xml.getNext());
                ++i;
            }
            if (xml.hasNext()) {
                throw new XMLStreamException("Too many elements");
            }
        }

        public void write(DenseVector V, XMLFormat.OutputElement xml) throws XMLStreamException {
            int dimension = V._elements.size();
            xml.setAttribute("dimension", dimension);
            int i = 0;
            while (i < dimension) {
                xml.add(V._elements.get(i++));
            }
        }
    };
    final FastTable<F> _elements = new FastTable();
    private static final ObjectFactory<DenseVector> FACTORY = new ObjectFactory<DenseVector>(){

        protected DenseVector create() {
            return new DenseVector();
        }

        protected void cleanup(DenseVector vector) {
            vector._elements.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> DenseVector<F> valueOf(F ... elements) {
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = elements.length;
        while (i < n) {
            V._elements.add(elements[i++]);
        }
        return V;
    }

    public static <F extends Field<F>> DenseVector<F> valueOf(List<F> elements) {
        DenseVector<F> V = DenseVector.newInstance();
        V._elements.addAll(elements);
        return V;
    }

    public static <F extends Field<F>> DenseVector<F> valueOf(Vector<F> that) {
        if (that instanceof DenseVector) {
            return (DenseVector)that;
        }
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = that.getDimension();
        while (i < n) {
            V._elements.add(that.get(i++));
        }
        return V;
    }

    @Override
    public int getDimension() {
        return this._elements.size();
    }

    @Override
    public F get(int i) {
        return (F)((Field)this._elements.get(i));
    }

    @Override
    public DenseVector<F> opposite() {
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = this._elements.size();
        while (i < n) {
            V._elements.add((Object)((Field)((Field)this._elements.get(i++)).opposite()));
        }
        return V;
    }

    @Override
    public DenseVector<F> plus(Vector<F> that) {
        int n = this._elements.size();
        if (that.getDimension() != n) {
            throw new DimensionException();
        }
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        while (i < n) {
            V._elements.add((Object)((Field)((Field)this._elements.get(i)).plus(that.get(i))));
            ++i;
        }
        return V;
    }

    @Override
    public DenseVector<F> minus(Vector<F> that) {
        return this.plus((Vector)that.opposite());
    }

    @Override
    public DenseVector<F> times(F k) {
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = this._elements.size();
        while (i < n) {
            V._elements.add((Object)((Field)((Field)this._elements.get(i++)).times(k)));
        }
        return V;
    }

    @Override
    public F times(Vector<F> that) {
        int n = this._elements.size();
        if (that.getDimension() != n) {
            throw new DimensionException();
        }
        StackContext.enter();
        try {
            Field sum = (Field)((Field)this._elements.get(0)).times(that.get(0));
            int i = 1;
            while (i < n) {
                sum = sum.plus((Field)((Field)this._elements.get(i)).times(that.get(i)));
                ++i;
            }
            Field field = (Field)StackContext.outerCopy((ValueType)sum);
            return (F)field;
        }
        finally {
            StackContext.exit();
        }
    }

    @Override
    public DenseVector<F> copy() {
        DenseVector<F> V = DenseVector.newInstance();
        for (Field e : this._elements) {
            V._elements.add((Object)((Field)e.copy()));
        }
        return V;
    }

    static <F extends Field<F>> DenseVector<F> newInstance() {
        return (DenseVector)FACTORY.object();
    }

    private DenseVector() {
    }
}

