/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ArrayFactory;
import javolution.lang.MathLib;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.Float64;
import org.jscience.mathematics.structure.VectorSpaceNormed;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Vector;

public final class Float64Vector
extends Vector<Float64>
implements VectorSpaceNormed<Vector<Float64>, Float64> {
    protected static final XMLFormat<Float64Vector> XML = new XMLFormat<Float64Vector>(Float64Vector.class){

        public Float64Vector newInstance(Class<Float64Vector> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            int dimension = xml.getAttribute("dimension", 0);
            Float64Vector V = (Float64Vector)FACTORY.array(dimension);
            V._dimension = dimension;
            return V;
        }

        public void read(XMLFormat.InputElement xml, Float64Vector V) throws XMLStreamException {
            int i = 0;
            int n = V._dimension;
            while (i < n) {
                V._values[i++] = ((Float64)xml.getNext()).doubleValue();
            }
            if (xml.hasNext()) {
                throw new XMLStreamException("Too many elements");
            }
        }

        public void write(Float64Vector V, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("dimension", V._dimension);
            int i = 0;
            int n = V._dimension;
            while (i < n) {
                xml.add((Object)V.get(i++));
            }
        }
    };
    private static final ArrayFactory<Float64Vector> FACTORY = new ArrayFactory<Float64Vector>(){

        protected Float64Vector create(int capacity) {
            return new Float64Vector(capacity);
        }
    };
    private int _dimension;
    private final double[] _values;
    private static final long serialVersionUID = 1L;

    private Float64Vector(int capacity) {
        this._values = new double[capacity];
    }

    public static Float64Vector valueOf(double ... values) {
        int n = values.length;
        Float64Vector V = (Float64Vector)FACTORY.array(n);
        V._dimension = n;
        System.arraycopy(values, 0, V._values, 0, n);
        return V;
    }

    public static Float64Vector valueOf(List<Float64> elements) {
        int n = elements.size();
        Float64Vector V = (Float64Vector)FACTORY.array(n);
        V._dimension = n;
        Iterator<Float64> iterator = elements.iterator();
        int i = 0;
        while (i < n) {
            V._values[i] = iterator.next().doubleValue();
            ++i;
        }
        return V;
    }

    public static Float64Vector valueOf(Vector<Float64> that) {
        if (that instanceof Float64Vector) {
            return (Float64Vector)that;
        }
        int n = that.getDimension();
        Float64Vector V = (Float64Vector)FACTORY.array(n);
        V._dimension = n;
        int i = 0;
        while (i < n) {
            V._values[i] = that.get(i).doubleValue();
            ++i;
        }
        return V;
    }

    public double getValue(int i) {
        if (i >= this._dimension) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._values[i];
    }

    @Override
    public Float64 norm() {
        return Float64.valueOf(this.normValue());
    }

    public double normValue() {
        double normSquared = 0.0;
        int i = this._dimension;
        while (--i >= 0) {
            double values = this._values[i];
            normSquared += values * values;
        }
        return MathLib.sqrt((double)normSquared);
    }

    @Override
    public int getDimension() {
        return this._dimension;
    }

    @Override
    public Float64 get(int i) {
        if (i >= this._dimension) {
            throw new IndexOutOfBoundsException();
        }
        return Float64.valueOf(this._values[i]);
    }

    @Override
    public Float64Vector opposite() {
        Float64Vector V = (Float64Vector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._values[i] = -this._values[i];
            ++i;
        }
        return V;
    }

    @Override
    public Float64Vector plus(Vector<Float64> that) {
        Float64Vector T = Float64Vector.valueOf(that);
        if (T._dimension != this._dimension) {
            throw new DimensionException();
        }
        Float64Vector V = (Float64Vector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._values[i] = this._values[i] + T._values[i];
            ++i;
        }
        return V;
    }

    public Float64Vector minus(Vector<Float64> that) {
        Float64Vector T = Float64Vector.valueOf(that);
        if (T._dimension != this._dimension) {
            throw new DimensionException();
        }
        Float64Vector V = (Float64Vector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._values[i] = this._values[i] - T._values[i];
            ++i;
        }
        return V;
    }

    @Override
    public Float64Vector times(Float64 k) {
        Float64Vector V = (Float64Vector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        double d = k.doubleValue();
        int i = 0;
        while (i < this._dimension) {
            V._values[i] = this._values[i] * d;
            ++i;
        }
        return V;
    }

    @Override
    public Float64Vector times(double k) {
        Float64Vector V = (Float64Vector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._values[i] = this._values[i] * k;
            ++i;
        }
        return V;
    }

    @Override
    public Float64 times(Vector<Float64> that) {
        Float64Vector T = Float64Vector.valueOf(that);
        if (T._dimension != this._dimension) {
            throw new DimensionException();
        }
        double[] T_values = T._values;
        double sum = this._values[0] * T_values[0];
        int i = 1;
        while (i < this._dimension) {
            sum += this._values[i] * T_values[i];
            ++i;
        }
        return Float64.valueOf(sum);
    }

    public Float64Vector cross(Vector<Float64> that) {
        Float64Vector T = Float64Vector.valueOf(that);
        if (this._dimension != 3 || T._dimension != 3) {
            throw new DimensionException("The cross product of two vectors requires 3-dimensional vectors");
        }
        double x = this._values[1] * T._values[2] - this._values[2] * T._values[1];
        double y = this._values[2] * T._values[0] - this._values[0] * T._values[2];
        double z = this._values[0] * T._values[1] - this._values[1] * T._values[0];
        return Float64Vector.valueOf(x, y, z);
    }

    @Override
    public Float64Vector copy() {
        Float64Vector V = (Float64Vector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._values[i] = this._values[i];
            ++i;
        }
        return V;
    }

    static Float64Vector newInstance(int n) {
        Float64Vector V = (Float64Vector)FACTORY.array(n);
        V._dimension = n;
        return V;
    }

    void set(int i, double v) {
        this._values[i] = v;
    }
}

