/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.commands.handlers;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationRegistry;
import org.modelversioning.emfprofile.application.registry.ui.observer.ActiveEditorObserver;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public class UnloadProfileApplicationHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "org.modelversioning.emfprofile.application.registry.ui.commands.unloadprofileapplication";
    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    Command saveCmd = this.commandService.getCommand("org.modelversioning.emfprofile.application.registry.ui.commands.saveprofileapplication");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection != null && currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof ProfileApplicationDecorator) {
                ProfileApplicationDecorator profileApplication = (ProfileApplicationDecorator)element;
                this.ifProfileApplicationDirty_AskToSave(profileApplication);
                BasicEList eObjects = new BasicEList();
                for (StereotypeApplication stereotypeApplication : profileApplication.getStereotypeApplications()) {
                    eObjects.add((Object)stereotypeApplication.getAppliedTo());
                }
                IEditorPart activeEditor = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActiveEditor();
                ProfileApplicationRegistry.INSTANCE.unloadProfileApplicationForModel(ActiveEditorObserver.INSTANCE.getModelIdForWorkbenchPart((IWorkbenchPart)activeEditor), profileApplication);
                ActiveEditorObserver.INSTANCE.refreshViewer();
                ActiveEditorObserver.INSTANCE.refreshDecorations((Collection<EObject>)eObjects);
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Not a profile application selected", (String)("selection: " + currentSelection.toString()));
            }
        } else {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Info", (String)"no selection in view");
        }
        return null;
    }

    private final void ifProfileApplicationDirty_AskToSave(ProfileApplicationDecorator profileApplication) {
        if (profileApplication.isDirty() && MessageDialog.openQuestion(null, (String)"Save Profile Application", (String)("Unloading unsaved Profile Application: " + profileApplication.getName() + "\nDo you wish to save it?"))) {
            ExecutionEvent executionEvent = this.handlerService.createExecutionEvent(this.saveCmd, new Event());
            ((IEvaluationContext)executionEvent.getApplicationContext()).addVariable("selection", (Object)new StructuredSelection((Object)profileApplication));
            try {
                this.saveCmd.executeWithChecks(executionEvent);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                System.err.println("Calling save command");
                e.printStackTrace();
            }
        }
    }
}

