/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import java.lang.reflect.Field;
import javax.swing.ImageIcon;
import org.opt4j.config.Icons;
import org.opt4j.config.Property;
import org.opt4j.config.PropertyModule;
import org.opt4j.config.annotations.Category;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Name;

public class Format {
    protected static final String xmlBreak = "<br/>";

    public String getName(Class<?> clazz) {
        int c;
        Name name = clazz.getAnnotation(Name.class);
        Category category = clazz.getAnnotation(Category.class);
        if (name != null && !"".equals(name.value())) {
            return name.value();
        }
        if (category != null && !"".equals(category.value())) {
            return category.value();
        }
        String n = clazz.getName();
        while ((c = n.indexOf(46)) != -1) {
            n = n.substring(c + 1);
        }
        if (n.endsWith("Module")) {
            n = n.substring(0, n.length() - "Module".length());
        }
        return n;
    }

    public String getInfo(Class<?> c) {
        Info info = c.getAnnotation(Info.class);
        String text = null;
        if (info != null && !"".equals(info.value())) {
            text = info.value();
        }
        return text;
    }

    public String getTooltip(Class<?> c) {
        String name = this.getName(c);
        String info = this.getInfo(c);
        String text = "<html><b>" + name + "</b>";
        if (info != null) {
            text = String.valueOf(text) + xmlBreak + info;
        }
        text = String.valueOf(text) + "</html>";
        return text;
    }

    public ImageIcon getIcon(Class<?> clazz) {
        Icon icon = clazz.getAnnotation(Icon.class);
        if (icon == null) {
            return null;
        }
        return Icons.getIcon(icon.value());
    }

    public String getName(PropertyModule module) {
        Class<?> c = module.getModule().getClass();
        return this.getName(c);
    }

    public String getTooltip(PropertyModule module) {
        Class<?> c = module.getModule().getClass();
        return this.getTooltip(c);
    }

    public ImageIcon getIcon(PropertyModule module) {
        Class<?> c = module.getModule().getClass();
        return this.getIcon(c);
    }

    public ImageIcon asFolder(ImageIcon icon) {
        ImageIcon i = Icons.getIcon("icons/folder.png");
        if (icon != null) {
            ImageIcon background = icon;
            ImageIcon foreground = Icons.getIcon("icons/small_folder.png");
            i = Icons.merge(background, foreground);
        }
        return i;
    }

    public String getName(Property property) {
        Name n = property.getAnnotation(Name.class);
        String name = n == null ? property.getName() : n.value();
        return name;
    }

    public String getTooltip(Property property) {
        String text = "<html><b>" + this.getName(property) + "</b>";
        String info = property.getInfo();
        if (info != null) {
            text = String.valueOf(text) + xmlBreak + info;
        }
        if (property.getType().isEnum()) {
            Field[] fields;
            Class<?> type = property.getType();
            text = String.valueOf(text) + xmlBreak;
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.isEnumConstant()) {
                    String name = field.getName();
                    Icon icon = field.getAnnotation(Icon.class);
                    Info i = field.getAnnotation(Info.class);
                    text = String.valueOf(text) + "&nbsp;" + name;
                    if (icon != null || i != null) {
                        text = String.valueOf(text) + " - ";
                    }
                    if (icon != null) {
                        text = String.valueOf(text) + "<img src=\"" + Icons.getURL(icon.value()) + "\">";
                        System.out.println(String.valueOf(text) + " " + icon.value());
                    }
                    if (i != null) {
                        text = String.valueOf(text) + i.value();
                    }
                    text = String.valueOf(text) + xmlBreak;
                }
                ++n2;
            }
        }
        text = String.valueOf(text) + "</html>";
        return text;
    }

    public String formatTooltip(String text) {
        return "<html>" + text.replaceAll("\n", xmlBreak) + "</html>";
    }
}

