/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import com.google.inject.Inject;
import java.util.Set;
import org.opt4j.core.Genotype;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objectives;
import org.opt4j.core.Phenotype;

public class Individual {
    protected Genotype genotype;
    protected Phenotype phenotype;
    protected Objectives objectives;
    protected Set<IndividualStateListener> individualStateListeners;
    protected State state = State.EMPTY;

    @Inject
    protected Individual() {
    }

    public Phenotype getPhenotype() {
        return this.phenotype;
    }

    public Objectives getObjectives() {
        return this.objectives;
    }

    public Genotype getGenotype() {
        return this.genotype;
    }

    public void setGenotype(Genotype genotype) {
        this.genotype = genotype;
        this.setState(State.GENOTYPED);
    }

    public void setPhenotype(Phenotype phenotype) {
        this.phenotype = phenotype;
        this.setState(State.PHENOTYPED);
    }

    public void setObjectives(Objectives objectives) {
        this.objectives = objectives;
        this.setState(State.EVALUATED);
    }

    public boolean isDecoded() {
        return this.state.isDecoded();
    }

    public boolean isEvaluated() {
        return this.state.isEvaluated();
    }

    public void setState(State state) {
        if (this.state != state) {
            this.state = state;
            for (IndividualStateListener listener : this.individualStateListeners) {
                listener.inidividualStateChanged(this);
            }
        }
    }

    public State getState() {
        return this.state;
    }

    protected void setIndividualStatusListeners(Set<IndividualStateListener> individualStateListeners) {
        this.individualStateListeners = individualStateListeners;
    }

    public static enum State {
        EMPTY("empty", false, false, false),
        GENOTYPED("genotyped", false, false, false),
        DECODING("decoding", false, false, true),
        PHENOTYPED("phenotyped", true, false, false),
        EVALUATING("evaluating", true, false, true),
        EVALUATED("evaluated", true, true, false);

        private final String name;
        private final boolean decoded;
        private final boolean evaluated;
        private final boolean processing;

        private State(String name, boolean decoded, boolean evaluated, boolean processing) {
            this.name = name;
            this.decoded = decoded;
            this.evaluated = evaluated;
            this.processing = processing;
        }

        public String toString() {
            return this.name;
        }

        public boolean isDecoded() {
            return this.decoded;
        }

        public boolean isEvaluated() {
            return this.evaluated;
        }

        public boolean isProcessing() {
            return this.processing;
        }
    }
}

