/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import org.opt4j.core.Criterion;
import org.opt4j.core.Value;

public class Objective
extends Criterion
implements Comparable<Objective> {
    public static final int RANK_OBJECTIVE = 0;
    public static final int RANK_ERROR = -100;
    public static final Value<?> INFEASIBLE = null;
    protected final Sign sign;
    protected final int rank;

    public Objective(String name) {
        this(name, Sign.MIN, 0);
    }

    public Objective(String name, Sign sign) {
        this(name, sign, 0);
    }

    public Objective(String name, Sign sign, int rank) {
        super(name);
        this.sign = sign;
        this.rank = rank;
    }

    public Sign getSign() {
        return this.sign;
    }

    public int getRank() {
        return this.rank;
    }

    @Override
    public int compareTo(Objective other) {
        if (this.equals(other)) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int diff = this.getRank() - other.getRank();
        if (diff != 0) {
            return diff;
        }
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + (Object)((Object)this.getSign()) + ")";
    }

    public static enum Sign {
        MIN,
        MAX;

    }
}

