/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.genotype;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.Bounds;
import org.opt4j.genotype.DoubleGenotype;
import org.opt4j.genotype.MapGenotype;

public class DoubleMapGenotype<K>
extends DoubleGenotype
implements MapGenotype<K, Double> {
    protected final List<K> keys;
    private static final long serialVersionUID = 1L;

    public DoubleMapGenotype(List<K> keys, Bounds<Double> bounds) {
        super(bounds);
        this.keys = keys;
    }

    public void init(Random random) {
        super.init(random, this.keys.size());
    }

    @Override
    public void init(Random random, int n) {
        throw new UnsupportedOperationException("Use method init(Random) instead");
    }

    @Override
    public boolean containsKey(K key) {
        return this.keys.contains(key);
    }

    @Override
    public Double getValue(K key) {
        int i = this.keys.indexOf(key);
        return (Double)this.get(i);
    }

    @Override
    public void setValue(K key, Double value) {
        int i = this.keys.indexOf(key);
        while (this.size() <= i) {
            this.add((Double)this.bounds.getLowerBound(i));
        }
        this.set(i, value);
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            Constructor<?> cstr = this.getClass().getConstructor(List.class, Bounds.class);
            return (G)((Genotype)cstr.newInstance(this.keys, this.bounds));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        String s = "[";
        int i = 0;
        while (i < this.size()) {
            K key = this.keys.get(i);
            double value = (Double)this.get(i);
            s = String.valueOf(s) + key + "=" + value + ";";
            ++i;
        }
        return String.valueOf(s) + "]";
    }

    @Override
    public int getIndexOf(K key) {
        return this.keys.indexOf(key);
    }

    @Override
    public Collection<K> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }
}

