/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.genotype;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.Bounds;
import org.opt4j.genotype.IntegerGenotype;
import org.opt4j.genotype.MapGenotype;

public class SelectMapGenotype<K, V>
extends IntegerGenotype
implements MapGenotype<K, V> {
    protected final List<K> keys;
    protected final Map<K, List<V>> values;
    private static final long serialVersionUID = 1L;

    public SelectMapGenotype(List<K> keys, Map<K, List<V>> values) {
        super(new SelectBounds<K, V>(keys, values));
        this.keys = keys;
        this.values = values;
    }

    private static <K, V> Map<K, List<V>> toMap(List<K> keys, List<V> values) {
        HashMap<K, List<V>> map = new HashMap<K, List<V>>();
        for (K key : keys) {
            map.put(key, values);
        }
        return map;
    }

    public SelectMapGenotype(List<K> keys, List<V> values) {
        super(new SelectBounds<K, V>(keys, SelectMapGenotype.toMap(keys, values)));
        this.keys = keys;
        this.values = SelectMapGenotype.toMap(keys, values);
    }

    public void init(Random random) {
        super.init(random, this.keys.size());
    }

    @Override
    public void init(Random random, int n) {
        throw new UnsupportedOperationException("Use method init(Random) instead");
    }

    @Override
    public boolean containsKey(K key) {
        return this.keys.contains(key);
    }

    @Override
    public int getIndexOf(K key) {
        return this.keys.indexOf(key);
    }

    @Override
    public V getValue(K key) {
        int i = this.getIndexOf(key);
        int v = (Integer)this.get(i);
        List<V> valueList = this.values.get(key);
        return valueList.get(v);
    }

    @Override
    public void setValue(K key, V value) {
        int i = this.keys.indexOf(key);
        while (this.size() <= i) {
            this.add((Integer)this.bounds.getLowerBound(i));
        }
        List<V> valueList = this.values.get(key);
        int v = valueList.indexOf(value);
        this.set(i, v);
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            Constructor<?> cstr = this.getClass().getConstructor(List.class, Map.class);
            return (G)((Genotype)cstr.newInstance(this.keys, this.values));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        String s = "[";
        int i = 0;
        while (i < this.size()) {
            K key = this.keys.get(i);
            int v = (Integer)this.get(i);
            V value = this.values.get(key).get(v);
            s = String.valueOf(s) + key + "=" + value + ";";
            ++i;
        }
        return String.valueOf(s) + "]";
    }

    @Override
    public Collection<K> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    protected static class SelectBounds<O, P>
    implements Bounds<Integer> {
        protected List<O> list;
        protected Map<O, List<P>> map;

        public SelectBounds(List<O> list, Map<O, List<P>> map) {
            this.list = list;
            this.map = map;
        }

        @Override
        public Integer getLowerBound(int index) {
            return 0;
        }

        @Override
        public Integer getUpperBound(int index) {
            return this.map.get(this.list.get(index)).size() - 1;
        }
    }
}

