/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.algebra;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.CompositeGenotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.algebra.Algebra;
import org.opt4j.operator.algebra.AlgebraDouble;
import org.opt4j.operator.algebra.Term;

@Singleton
public class AlgebraGenericImplementation
extends AbstractGenericOperator<Algebra<Genotype>, Algebra<?>>
implements Algebra<Genotype> {
    @Inject
    protected AlgebraGenericImplementation() {
        super(AlgebraDouble.class);
    }

    @Override
    public Genotype algebra(Term term, Genotype ... genotypes) {
        Algebra algebra = (Algebra)this.getOperator(genotypes[0]);
        if (algebra == null) {
            return this.algebraComposite(term, genotypes);
        }
        return algebra.algebra(term, genotypes);
    }

    protected CompositeGenotype<?, ?> algebraComposite(Term term, Genotype ... genotypes) {
        int n = genotypes.length;
        ArrayList<CompositeGenotype> composites = new ArrayList<CompositeGenotype>();
        int i = 0;
        while (i < n) {
            composites.add((CompositeGenotype)genotypes[i]);
            ++i;
        }
        CompositeGenotype offspring = (CompositeGenotype)((CompositeGenotype)composites.get(0)).newInstance();
        for (Object key : ((CompositeGenotype)composites.get(0)).keySet()) {
            Genotype[] g = new Genotype[n];
            int i2 = 0;
            while (i2 < n) {
                Genotype genotype;
                g[i2] = composites.get(i2) == null ? null : (genotype = (Genotype)((CompositeGenotype)composites.get(i2)).get(key));
                ++i2;
            }
            Genotype value = this.algebra(term, g);
            offspring.put(key, value);
        }
        return offspring;
    }
}

