/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.crossover;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.List;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.genotype.DoubleGenotype;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.operator.crossover.CrossoverDoubleDefault;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.ea.Pair;

@ImplementedBy(value=CrossoverDoubleDefault.class)
public abstract class CrossoverDouble
implements Crossover<DoubleGenotype> {
    protected final Random random;
    protected final NormalizeDouble normalize;

    @Inject
    public CrossoverDouble(NormalizeDouble normalize, Rand random) {
        this.normalize = normalize;
        this.random = random;
    }

    @Override
    public Pair<DoubleGenotype> crossover(DoubleGenotype p1, DoubleGenotype p2) {
        DoubleGenotype o1 = (DoubleGenotype)p1.newInstance();
        DoubleGenotype o2 = (DoubleGenotype)p2.newInstance();
        this.crossover(p1, p2, o1, o2);
        this.normalize.normalize(o1);
        this.normalize.normalize(o2);
        Pair<DoubleGenotype> offspring = new Pair<DoubleGenotype>(o1, o2);
        return offspring;
    }

    protected abstract void crossover(List<Double> var1, List<Double> var2, List<Double> var3, List<Double> var4);
}

